/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.distance;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.patch.Patch;
import fr.inra.sad.bagap.apiland.patch.PatchComposite;

public class PatchDistanceCountingOld
extends CountingDecorator {
    private PatchComposite patches;

    public PatchDistanceCountingOld(Counting decorate) {
        super(decorate);
    }

    @Override
    protected void doDown(int d, int place) {
        this.patches.upPixels();
    }

    @Override
    protected void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.patches.addPixel(new Pixel(x, y), (int)value);
        }
    }

    @Override
    protected void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.patches.removePixel(new Pixel(x, y), (int)value);
        }
    }

    @Override
    protected void doInit() {
        this.patches = new PatchComposite();
    }

    @Override
    protected void doDelete() {
        this.patches = null;
    }

    @Override
    public PatchComposite patches() {
        return this.patches;
    }

    @Override
    public double getPatchNumber() {
        double nb = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            double pnb = 0.0;
            for (Pixel pixel : p.pixels()) {
                pnb += this.process().window().weighted()[pixel.y()][pixel.x()];
            }
            nb += (pnb /= (double)p.pixels().size());
        }
        if (nb > 0.0) {
            return nb;
        }
        return 0.0;
    }

    @Override
    public double getPatchNumber(int classe) {
        double nb = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            double pnb = 0.0;
            for (Pixel pixel : p.pixels()) {
                pnb += this.process().window().weighted()[pixel.y()][pixel.x()];
            }
            nb += (pnb /= (double)p.pixels().size());
        }
        if (nb > 0.0) {
            return nb;
        }
        return 0.0;
    }

    @Override
    public double getLargestPatchSize() {
        double value = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            double area = 0.0;
            for (Pixel pixel : p.pixels()) {
                area += this.process().window().weighted()[pixel.y()][pixel.x()];
            }
            value = Math.max(value, area *= Math.pow(Raster.getCellSize(), 2.0));
        }
        return value /= 10000.0;
    }

    @Override
    public double getLargestPatchSize(int classe) {
        double value = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            double area = 0.0;
            for (Pixel pixel : p.pixels()) {
                area += this.process().window().weighted()[pixel.y()][pixel.x()];
            }
            value = Math.max(value, area *= Math.pow(Raster.getCellSize(), 2.0));
        }
        return value /= 10000.0;
    }

    @Override
    public double getMeanPatchSize() {
        double area = 0.0;
        double nb = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() == 0) continue;
            double parea = 0.0;
            double pnb = 0.0;
            for (Pixel pixel : p.pixels()) {
                double weight = this.process().window().weighted()[pixel.y()][pixel.x()];
                parea += weight;
                pnb += weight;
            }
            if (parea > 0.0) {
                area += (parea *= Math.pow(Raster.getCellSize(), 2.0));
            }
            if (!(pnb > 0.0)) continue;
            nb += (pnb /= (double)p.pixels().size());
        }
        if (nb != 0.0) {
            return area / nb;
        }
        return 0.0;
    }

    @Override
    public double getMeanPatchSize(int classe) {
        double area = 0.0;
        double nb = 0.0;
        for (Patch p : this.patches.patches()) {
            if (p.getValue() != classe) continue;
            double parea = 0.0;
            double pnb = 0.0;
            for (Pixel pixel : p.pixels()) {
                double weight = this.process().window().weighted()[pixel.y()][pixel.x()];
                parea += weight;
                pnb += weight;
            }
            if (parea > 0.0) {
                area += (parea *= Math.pow(Raster.getCellSize(), 2.0));
            }
            if (!(pnb > 0.0)) continue;
            nb += (pnb /= (double)p.pixels().size());
        }
        if (nb != 0.0) {
            return area / nb;
        }
        return 0.0;
    }
}

