/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.distance;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.CountingDecorator;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class QuantitativeDistanceCounting
extends CountingDecorator {
    private final int size;
    private double[][] datas;
    private boolean calculated;
    private double count;
    private double sum;
    private double max;
    private double min;
    private double squareSum;
    private double countPos;
    private double countNeg;

    public QuantitativeDistanceCounting(Counting decorate, int size) {
        super(decorate);
        this.size = size;
    }

    @Override
    public void doInit() {
        this.datas = new double[this.size][this.size];
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                this.datas[j][i] = Raster.getNoDataValue();
            }
        }
        this.calculated = false;
    }

    @Override
    protected void doDown(int d, int place) {
        double[] tnewFill = new double[this.size];
        Arrays.fill(tnewFill, (double)Raster.getNoDataValue());
        this.datas = (double[][])Arrays.copyOfRange(this.datas, 1, this.datas.length);
        this.datas = (double[][])ArrayUtils.addAll((Object[])this.datas, (Object[])new double[][]{tnewFill});
        this.calculated = false;
    }

    @Override
    public void doAdd(double value, int x, int y, int filter, double ch, double cv) {
        this.doAddValue(value, x, y);
    }

    @Override
    protected void doAddValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.datas[y][x] = value;
        }
    }

    @Override
    public void doRemoveValue(double value, int x, int y) {
        if (value != (double)Raster.getNoDataValue()) {
            this.datas[y][x] = Raster.getNoDataValue();
        }
    }

    @Override
    public void doDelete() {
        this.datas = null;
    }

    private void calculate() {
        this.count = 0.0;
        this.sum = 0.0;
        this.max = Double.MIN_VALUE;
        this.min = Double.MAX_VALUE;
        this.squareSum = 0.0;
        this.countPos = 0.0;
        this.countNeg = 0.0;
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                double v = this.datas[j][i];
                if (v == (double)Raster.getNoDataValue()) continue;
                double weight = this.process().window().weighted()[j][i];
                double produit = weight * v;
                this.count += weight;
                this.sum += produit;
                this.max = Math.max(this.max, produit);
                this.min = Math.min(this.min, produit);
                this.squareSum += Math.pow(produit, 2.0);
                if (produit > 0.0) {
                    this.countPos += weight;
                }
                if (!(produit < 0.0)) continue;
                this.countNeg += weight;
            }
        }
        this.calculated = true;
    }

    @Override
    public double size() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.count;
    }

    @Override
    public double getSum() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.sum;
    }

    @Override
    public double getAverage() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.count == 0.0) {
            return Raster.getNoDataValue();
        }
        return this.sum / this.count;
    }

    @Override
    public double getMaximum() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.max != Double.MIN_VALUE) {
            return this.max;
        }
        return Raster.getNoDataValue();
    }

    @Override
    public double getMinimum() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.min != Double.MAX_VALUE) {
            return this.min;
        }
        return Raster.getNoDataValue();
    }

    @Override
    public double getSquareSum() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.squareSum;
    }

    @Override
    public double countPositives() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.countPos;
    }

    @Override
    public double countNegatives() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.countNeg;
    }

    @Override
    public double getVariance() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.count == 0.0) {
            return Raster.getNoDataValue();
        }
        return this.squareSum / this.count - Math.pow(this.sum / this.count, 2.0);
    }

    @Override
    public double getStandardDeviation() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.count == 0.0) {
            return Raster.getNoDataValue();
        }
        return Math.sqrt(this.squareSum / this.count - Math.pow(this.sum / this.count, 2.0));
    }

    @Override
    public double getStandardError() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.count == 0.0) {
            return Raster.getNoDataValue();
        }
        return Math.sqrt(this.squareSum / this.count - Math.pow(this.sum / this.count, 2.0)) / Math.sqrt(this.count);
    }

    @Override
    public double getVariationCoefficient() {
        if (!this.calculated) {
            this.calculate();
        }
        if (this.count == 0.0) {
            return Raster.getNoDataValue();
        }
        return 100.0 * Math.sqrt(this.squareSum / this.count - Math.pow(this.sum / this.count, 2.0)) / (this.sum / this.count);
    }

    @Override
    public double getTruncatedAverage(double threshold) {
        double value = 0.0;
        double count = 0.0;
        double v2 = 0.0;
        for (int j = 0; j < this.size; ++j) {
            for (int i = 0; i < this.size; ++i) {
                double v = this.datas[j][i];
                if (v == (double)Raster.getNoDataValue()) continue;
                double weight = this.process().window().weighted()[j][i];
                count += weight;
                if ((v *= weight) <= threshold) {
                    v2 += v / threshold;
                    continue;
                }
                v2 += 1.0;
            }
        }
        value = count == 0.0 ? 0.0 : v2 / count;
        return value;
    }
}

