/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.qualitative.value;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.counting.Counting;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.DistanceValueMetric;
import fr.inra.sad.bagap.apiland.analysis.process.metric.ValueMetric;
import fr.inra.sad.bagap.apiland.core.util.DistanceValueMatrix;
import java.util.TreeSet;

public class RaoQIndex
extends MatrixMetric
implements ValueMetric,
DistanceValueMetric {
    private DistanceValueMatrix distances;

    public RaoQIndex() {
        super(VariableManager.get("RaoQ"));
    }

    @Override
    public void setDistanceMatrix(DistanceValueMatrix dvm) {
        this.distances = dvm;
    }

    @Override
    public void doCalculate(Counting co) {
        if (co.countValues() > 0.0) {
            this.value = 0.0;
            TreeSet<Integer> ever = new TreeSet<Integer>();
            for (int v1 : co.values()) {
                ever.add(v1);
                double p1 = co.countValue(v1) / co.validValues();
                for (int v2 : co.values()) {
                    if (ever.contains(v2)) continue;
                    double p2 = co.countValue(v2) / co.validValues();
                    this.value += this.distances.getDistance(v1, v2) * p1 * p2;
                }
            }
        }
    }
}

