/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.VolatileWindowAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;

public class GridWindowMatrixAnalysis
extends WindowMatrixAnalysis
implements VolatileWindowAnalysis {
    private final int gridSize;
    private int xp;
    private int yp;
    private int nextx;
    private int nexty;

    public GridWindowMatrixAnalysis(Matrix m, Window w, WindowMatrixProcessType pType, int d, double minRate) {
        super(m, w, pType);
        this.gridSize = d;
        Metric.setMinRate(minRate);
    }

    @Override
    public int delta() {
        return this.gridSize;
    }

    @Override
    public Pixel next(Pixel pixel) {
        Pixel p = PixelManager.get(pixel.x() + this.gridSize, pixel.y());
        if (this.matrix().contains(p)) {
            return p;
        }
        p = PixelManager.get(0, pixel.y() + this.gridSize);
        if (this.matrix().contains(p)) {
            return p;
        }
        return null;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doRun() {
        this.nextx = 0;
        this.nexty = 0;
        for (int yt = 0; yt < this.matrix().numYTiles(); ++yt) {
            int ypt = this.yp = this.nexty;
            for (int xt = 0; xt < this.matrix().numXTiles(); ++xt) {
                this.xp = this.nextx;
                this.yp = ypt;
                this.createProcesses(xt, yt);
            }
        }
    }

    private void createProcesses(int xt, int yt) {
        if (yt % this.gridSize == 0) {
            boolean yi = false;
            boolean xi = false;
            int x = this.xp;
            while (this.yp < (yt + 1) * this.matrix().tileHeight() + this.window().height() / 2 + 1 && this.yp < this.matrix().height()) {
                yi = true;
                this.xp = x;
                while (this.xp < (xt + 1) * this.matrix().tileWidth() + this.window().width() / 2 + 1 && this.xp < this.matrix().width()) {
                    xi = true;
                    WindowMatrixProcess wp = this.processType().create(this.window(), PixelManager.get(this.xp, this.yp));
                    this.distributeValues(wp, this.xp, this.yp);
                    this.xp += this.gridSize;
                }
                this.yp += this.gridSize;
            }
            if (!xi || !yi || this.xp < this.matrix().width() || this.yp < this.matrix().height()) {
                if (xi) {
                    this.nextx = this.xp >= this.matrix().width() ? 0 : this.xp;
                }
                if (yi) {
                    this.nexty = this.yp >= this.matrix().height() ? 0 : this.yp;
                }
            } else {
                this.nextx = 0;
                this.nexty = this.yp;
            }
        }
    }

    private void distributeValues(WindowMatrixProcess wp, int xp, int yp) {
        int total = this.matrix().width() * this.matrix().height();
        for (int y = yp; y < yp + this.gridSize && y < this.matrix().height(); ++y) {
            for (int x = xp; x < xp + this.gridSize && x < this.matrix().width(); ++x) {
                double v = this.matrix().get(x, y);
                this.processType().setValue(x, y, v, null);
                wp.add(x, y, v);
                this.updateProgression(total);
            }
        }
        wp.calculateMetrics();
    }

    @Override
    public void notify(Process p, ProcessState s) {
    }
}

