/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcess;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.VolatileWindowAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.Map;
import java.util.TreeMap;

public class GridWindowMatrixAnalysisOld
extends WindowMatrixAnalysis
implements VolatileWindowAnalysis {
    private final int gridSize;
    private Map<Integer, Map<Integer, WindowMatrixProcess>> processes;
    private int xp;
    private int yp;
    private int nextx;
    private int nexty;

    public GridWindowMatrixAnalysisOld(Matrix m, Window w, WindowMatrixProcessType pType, int d, double minRate) {
        super(m, w, pType);
        this.gridSize = d;
        Metric.setMinRate(minRate);
    }

    @Override
    public int delta() {
        return this.gridSize;
    }

    @Override
    public Pixel next(Pixel pixel) {
        Pixel p = PixelManager.get(pixel.x() + this.gridSize, pixel.y());
        if (this.matrix().contains(p)) {
            return p;
        }
        p = PixelManager.get(0, pixel.y() + this.gridSize);
        if (this.matrix().contains(p)) {
            return p;
        }
        return null;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doRun() {
        this.processes = new TreeMap<Integer, Map<Integer, WindowMatrixProcess>>();
        this.nextx = 0;
        this.nexty = 0;
        for (int yt = 0; yt < this.matrix().numYTiles(); ++yt) {
            int ypt = this.yp = this.nexty;
            for (int xt = 0; xt < this.matrix().numXTiles(); ++xt) {
                this.xp = this.nextx;
                this.yp = ypt;
                this.createProcesses(xt, yt);
                this.distributeValues(xt, yt);
            }
        }
    }

    private void createProcesses(int xt, int yt) {
        if (yt % this.gridSize == 0) {
            boolean yi = false;
            boolean xi = false;
            int x = this.xp;
            while (this.yp < (yt + 1) * this.matrix().tileHeight() + this.window().height() / 2 + 1 && this.yp < this.matrix().height()) {
                yi = true;
                if (!this.processes.containsKey(this.yp)) {
                    this.processes.put(this.yp, new TreeMap());
                }
                this.xp = x;
                while (this.xp < (xt + 1) * this.matrix().tileWidth() + this.window().width() / 2 + 1 && this.xp < this.matrix().width()) {
                    xi = true;
                    if (!this.processes.get(this.yp).containsKey(this.xp)) {
                        System.out.println("creation du processus en " + this.xp + " " + this.yp);
                        WindowMatrixProcess wp = this.processType().create(this.window(), PixelManager.get(this.xp, this.yp));
                        this.processes.get(this.yp).put(this.xp, wp);
                    }
                    this.xp += this.gridSize;
                }
                this.yp += this.gridSize;
            }
            if (!xi || !yi || this.xp < this.matrix().width() || this.yp < this.matrix().height()) {
                if (xi) {
                    this.nextx = this.xp >= this.matrix().width() ? 0 : this.xp;
                }
                if (yi) {
                    this.nexty = this.yp >= this.matrix().height() ? 0 : this.yp;
                }
            } else {
                this.nextx = 0;
                this.nexty = this.yp;
            }
        }
    }

    private void distributeValues(int xt, int yt) {
        if (xt % this.gridSize == 0) {
            int total = this.matrix().width() * this.matrix().height();
            for (int y = yt * this.matrix().tileHeight(); y < (yt + 1) * this.matrix().tileHeight() && y < this.matrix().height(); ++y) {
                for (int x = xt * this.matrix().tileWidth(); x < (xt + 1) * this.matrix().tileWidth() && x < this.matrix().width(); ++x) {
                    double v = this.matrix().get(x, y);
                    this.processType().setValue(x, y, v, null);
                    boolean ok = false;
                    for (int iy = y - this.window().height() + 1; !ok && iy <= y; ++iy) {
                        if (!this.processes.containsKey(iy)) continue;
                        for (int ix = x - this.window().width() + 1; !ok && ix <= x; ++ix) {
                            if (!this.processes.get(iy).containsKey(ix)) continue;
                            this.processes.get(iy).get(ix).add(x, y, v);
                            ok = true;
                        }
                    }
                    this.updateProgression(total);
                }
            }
        }
    }

    @Override
    public void notify(Process p, ProcessState s) {
        if (p instanceof WindowMatrixProcess && p.processType().equals(this.processType())) {
            switch (s) {
                case INIT: {
                    this.notifyProcessInit((WindowMatrixProcess)p);
                    break;
                }
                case READY: {
                    this.notifyProcessReady((WindowMatrixProcess)p);
                    break;
                }
                case DONE: {
                    this.notifyProcessDone((WindowMatrixProcess)p);
                }
            }
        }
    }

    private void notifyProcessInit(WindowMatrixProcess p) {
    }

    private void notifyProcessReady(WindowMatrixProcess p) {
        p.calculateMetrics();
    }

    private void notifyProcessDone(WindowMatrixProcess p) {
        p.delete();
    }
}

