/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.GridWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.MapWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.NaiveSelectedWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.SelectedWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.SlidingWindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.CenteredWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.cluster.Cluster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.util.HashSet;
import java.util.Set;

public class WindowMatrixAnalysisBuilder {
    private WindowAnalysisType type;
    private Set<Matrix> matrix;
    private Window window;
    private WindowMatrixProcessType processType;
    private int displacement;
    private int xOrigin;
    private int yOrigin;
    private Set<WindowAnalysisObserver> observers;
    private Matrix matrixFilter;
    private Matrix matrixUnFilter;
    private Set<Integer> filters;
    private Set<Integer> unfilters;
    private boolean exportFilters;
    private Set<Pixel> pixels;
    private double minRate;
    private Set<Cluster> clusters;
    private String path;

    public WindowMatrixAnalysisBuilder(WindowAnalysisType t) {
        this.type = t;
        this.observers = new HashSet<WindowAnalysisObserver>();
        this.filters = new HashSet<Integer>();
        this.unfilters = new HashSet<Integer>();
        this.matrix = new HashSet<Matrix>();
        this.reset();
    }

    private void reset() {
        this.window = null;
        this.processType = null;
        this.displacement = 1;
        this.xOrigin = 0;
        this.yOrigin = 0;
        this.minRate = 0.0;
        this.observers.clear();
        this.filters.clear();
        this.unfilters.clear();
        this.exportFilters = false;
        this.matrix.clear();
        this.matrixFilter = null;
        this.matrixUnFilter = null;
        this.clusters = null;
        this.path = null;
    }

    public void setExportFilters(boolean export) {
        this.exportFilters = export;
    }

    public void addMatrix(Matrix m) {
        this.matrix.add(m);
    }

    public void setMatrix(Set<Matrix> m) {
        this.matrix.addAll(m);
    }

    public void setWindow(Window w) {
        this.window = w;
    }

    public void setProcessType(WindowMatrixProcessType pt) {
        this.processType = pt;
    }

    public void setDisplacement(int d) {
        this.displacement = d;
    }

    public void setXOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public void setYOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    public void setMinRate(double mr) {
        this.minRate = mr;
    }

    public void setPixels(Set<Pixel> p) {
        this.pixels = p;
    }

    public void addObserver(WindowAnalysisObserver o) {
        this.observers.add(o);
    }

    public void addFilter(Matrix m) {
        this.matrixFilter = m;
    }

    public void addFilter(int f) {
        this.filters.add(f);
    }

    public void setFilters(Set<Integer> f) {
        this.filters.addAll(f);
    }

    public void addUnFilter(Matrix m) {
        this.matrixUnFilter = m;
    }

    public void addUnfilter(int f) {
        this.unfilters.add(f);
    }

    public void setUnfilters(Set<Integer> f) {
        this.unfilters.addAll(f);
    }

    public void setClusters(Set<Cluster> clusters) {
        this.clusters = clusters;
    }

    public void setPath(String path) {
        this.path = path.endsWith("/") ? path : path + "/";
    }

    public <W extends WindowMatrixAnalysis> W build() {
        Analysis wa = null;
        Matrix[] mat = new Matrix[this.matrix.size()];
        int index = 0;
        for (Matrix m : this.matrix) {
            mat[index++] = m;
        }
        switch (this.type) {
            case SLIDING: {
                wa = new SlidingWindowMatrixAnalysis(mat[0], this.window, this.processType, this.displacement, this.xOrigin, this.yOrigin, this.minRate, this.filters, this.unfilters, this.matrixFilter, this.matrixUnFilter);
                break;
            }
            case SELECTED: {
                if (this.window instanceof MultipleWindow || ((CenteredWindow)this.window).shape().getDistanceFunction() == null) {
                    wa = new SelectedWindowMatrixAnalysis(mat[0], this.window, this.processType, this.minRate, this.pixels, this.path, this.exportFilters);
                    break;
                }
                wa = new NaiveSelectedWindowMatrixAnalysis(mat[0], this.window, this.processType, this.minRate, this.pixels, this.path, this.exportFilters);
                break;
            }
            case MAP: {
                wa = new MapWindowMatrixAnalysis(mat[0], this.window, this.processType, this.matrixFilter, this.matrixUnFilter);
                break;
            }
            case GRID: {
                wa = new GridWindowMatrixAnalysis(mat[0], this.window, this.processType, this.displacement, this.minRate);
            }
        }
        for (WindowAnalysisObserver o : this.observers) {
            wa.addObserver(o);
            this.processType.addObserver(o);
            for (Metric wm : this.processType.metrics()) {
                wm.addObserver(o);
            }
        }
        this.reset();
        return (W)wa;
    }
}

