/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.FunctionalWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;

public class FunctionalWindowWithMatrix
extends FunctionalWindow {
    private Matrix friction;

    public FunctionalWindowWithMatrix(Matrix m, double d, Matrix f, DistanceFunction function) {
        super(m, d, f.minV(), function);
        this.friction = f;
        this.initTheoriticalSize();
    }

    public FunctionalWindowWithMatrix(Matrix m, double d, Matrix f) {
        super(m, d, f.minV());
        this.friction = f;
        this.initTheoriticalSize();
    }

    public FunctionalWindowWithMatrix(Matrix m, double d, int displacement, Matrix f, DistanceFunction function) {
        super(m, d, (double)displacement, function);
        this.friction = f;
        this.initTheoriticalSize();
    }

    public FunctionalWindowWithMatrix(Matrix m, double d, int displacement, Matrix f) {
        super(m, d, displacement);
        this.friction = f;
        this.initTheoriticalSize();
    }

    @Override
    public int width() {
        int v = new Double(2.0 * this.dMax / this.matrix.cellsize() + 1.0).intValue();
        if (v % 2 == 0) {
            return v - 1;
        }
        return v;
    }

    @Override
    public int height() {
        int v = new Double(2.0 * this.dMax / this.matrix.cellsize() + 1.0).intValue();
        if (v % 2 == 0) {
            return v - 1;
        }
        return v;
    }

    @Override
    protected double friction(Matrix m, Pixel p) {
        return this.window.get(this.friction, p);
    }
}

