/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.matrix.window.shape;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShape;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelWithID;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class LocateFunctionalWindow
extends WindowShape {
    private int[] filter;
    private int width;
    private double[][] distance;
    private double[][] weighted;
    private double[][] weightedH;
    private double[][] weightedV;

    public LocateFunctionalWindow(int[] f, DistanceFunction function) {
        super(function);
        this.filter = f;
        this.width = new Double(Math.sqrt(this.filter.length)).intValue();
    }

    @Override
    public double[][] weighted() {
        if (this.weighted == null) {
            this.initWeighted();
        }
        return this.weighted;
    }

    @Override
    public double[][] weightedH() {
        if (this.weightedH == null) {
            if (this.weighted == null) {
                this.initWeighted();
            }
            this.initWeightedCouple();
        }
        return this.weightedH;
    }

    @Override
    public double[][] weightedV() {
        if (this.weightedV == null) {
            if (this.weighted == null) {
                this.initWeighted();
            }
            this.initWeightedCouple();
        }
        return this.weightedV;
    }

    protected void initWeighted() {
        this.distance = new double[this.width][this.width];
        double rayon = this.width / 2;
        WKTReader wkt = new WKTReader();
        try {
            Point center = (Point)wkt.read("POINT (" + (rayon + 0.5) + " " + (rayon + 0.5) + ")");
            int j = 0;
            int i = 0;
            for (double y = 0.5; y < (double)this.width; y += 1.0) {
                for (double x = 0.5; x < (double)this.width; x += 1.0) {
                    Point p = (Point)wkt.read("POINT (" + x + " " + y + ")");
                    double d = center.distance((Geometry)p);
                    this.distance[j][i] = d > rayon ? (double)Raster.getNoDataValue() : d * Raster.getCellSize();
                    ++i;
                }
                ++j;
                i = 0;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.weighted = new double[this.width][this.width];
        for (int j = 0; j < this.width; ++j) {
            for (int i = 0; i < this.width; ++i) {
                this.weighted[j][i] = this.getDistanceFunction().interprete(this.distance[j][i]);
            }
        }
    }

    protected void initWeightedCouple() {
        int i;
        int j;
        this.weightedH = new double[this.width][this.width - 1];
        for (j = 0; j < this.width; ++j) {
            for (i = 0; i < this.width - 1; ++i) {
                this.weightedH[j][i] = this.getDistanceFunction().interprete((this.distance[j][i] + this.distance[j][i + 1]) / 2.0);
            }
        }
        this.weightedV = new double[this.width - 1][this.width];
        for (j = 0; j < this.width - 1; ++j) {
            for (i = 0; i < this.width; ++i) {
                this.weightedV[j][i] = this.getDistanceFunction().interprete((this.distance[j][i] + this.distance[j + 1][i]) / 2.0);
            }
        }
    }

    public String getStringFilter() {
        StringBuffer sb = new StringBuffer();
        for (int f : this.filter) {
            sb.append(f);
        }
        return sb.toString();
    }

    protected int[] filters() {
        return this.filter;
    }

    @Override
    public int filter(int wx, int wy) {
        return this.filter[wy * this.width + wx];
    }

    @Override
    public int theoreticalSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void display() {
        int index = 0;
        for (int f : this.filter) {
            System.out.print(f + " ");
            if (++index % this.width != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    @Override
    public void export(Pixel p, Matrix m, String path) {
        try {
            String name = new File(m.getFile()).getName().replace(".asc", "");
            String file = "";
            file = p instanceof PixelWithID ? path + name + "_functional_" + this.width + "_" + ((PixelWithID)p).getId() + ".asc" : path + name + "_functional_" + this.width + "_" + CoordinateManager.getProjectedX(m, p.x()) + "-" + CoordinateManager.getProjectedY(m, p.y()) + ".asc";
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            double delta = (double)this.width / 2.0;
            double X = CoordinateManager.getProjectedX(m, p.x());
            double nX = X - delta * Raster.getCellSize();
            double Y = CoordinateManager.getProjectedY(m, p.y());
            double nY = Y - delta * Raster.getCellSize();
            out.write("ncols ");
            out.write(this.width + "");
            out.newLine();
            out.write("nrows ");
            out.write(this.width + "");
            out.newLine();
            out.write("xllcorner ");
            out.write(nX + "");
            out.newLine();
            out.write("yllcorner ");
            out.write(nY + "");
            out.newLine();
            out.write("cellsize ");
            out.write(Raster.getCellSize() + "");
            out.newLine();
            out.write("NODATA_value  ");
            out.write(Raster.getNoDataValue() + "");
            out.newLine();
            int index = 0;
            for (int j = p.y() - this.width / 2; j < p.y() + 1 + this.width / 2; ++j) {
                for (int i = p.x() - this.width / 2; i < p.x() + 1 + this.width / 2; ++i) {
                    if (this.filter[index++] == 0) {
                        out.write("-1 ");
                        continue;
                    }
                    out.write(m.get(i, j) + " ");
                }
                out.newLine();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int width() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int height() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (other instanceof LocateFunctionalWindow) {
            LocateFunctionalWindow l = (LocateFunctionalWindow)other;
            for (int s = 0; s < this.filter.length; ++s) {
                if (this.filter[s] == l.filter[s]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int s = 0; s < this.filter.length; ++s) {
            h += this.filter[s];
        }
        return h;
    }

    @Override
    public List<Pixel> removeDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> removeHorizontalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addHorizontalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> removeVerticalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pixel> addVerticalDownList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void infos() {
    }
}

