/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.process.metric;

import fr.inra.sad.bagap.apiland.analysis.Variable;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.metric.MetricObserver;
import java.util.HashSet;
import java.util.Set;

public abstract class Metric
implements Comparable<Metric> {
    protected static double minRate = 0.0;
    private Variable variable;
    private Set<MetricObserver> observers;
    protected double value;

    public Metric(Variable v) {
        this.variable = v;
        this.observers = new HashSet<MetricObserver>();
    }

    public String toString() {
        return this.variable.getName();
    }

    public static void setMinRate(double min) {
        minRate = min;
    }

    public static double minRate() {
        return minRate;
    }

    public void setVariable(Variable v) {
        this.variable = v;
    }

    public String getName() {
        return this.variable.getName();
    }

    public void addObserver(MetricObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(MetricObserver o) {
    }

    public void notifyObservers(Process wp, String pref) {
        for (MetricObserver o : this.observers) {
            o.notify(this, pref + this.variable.getName(), this.value, wp);
        }
    }

    @Override
    public int compareTo(Metric m) {
        return this.getName().compareTo(m.getName());
    }
}

