/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ConnectivityMetricOld
extends VectorMetric {
    private String attribute;
    private Object code;

    public ConnectivityMetricOld(String attribute, Object code) {
        super(VariableManager.get("C_" + code));
        this.attribute = attribute;
        this.code = code;
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        this.value = 0.0;
        for (Polygon p : polygons) {
            if (!((Composition)p.getUserData()).getAttribute(this.attribute).isActive(t) || !((Composition)p.getUserData()).getAttribute(this.attribute).getValue(t).equals(this.code)) continue;
            this.value += Math.exp(-(point.distance((Geometry)p) / 1000.0)) * p.getArea();
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

