/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.metric;

import fr.inra.sad.bagap.apiland.analysis.VariableManager;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.core.composition.Composition;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class EdgeLengthMetric
extends VectorMetric {
    private Object code1;
    private Object code2;

    public EdgeLengthMetric(Object code1, Object code2) {
        super(VariableManager.get("E_" + code1 + "-" + code2));
        this.code1 = code1;
        this.code2 = code2;
    }

    private Set<Polygon> getBuffers(Point point, Set<Polygon> polygons) {
        return this.calculateBuffers(polygons);
    }

    private Set<Polygon> calculateBuffers(Set<Polygon> polygons) {
        HashSet<Polygon> buffers = new HashSet<Polygon>();
        for (Polygon p : polygons) {
            Polygon buffer = (Polygon)p.buffer(0.5);
            buffer.setUserData(p.getUserData());
            buffers.add(buffer);
        }
        return buffers;
    }

    private Geometry getIntersection(Point point, Polygon buffer1, Polygon buffer2) {
        return buffer1.intersection((Geometry)buffer2);
    }

    @Override
    public void doCalculate(Point point, Set<Polygon> polygons, Instant t) {
        Set<Polygon> buffers = this.getBuffers(point, polygons);
        this.value = 0.0;
        if (this.code1 instanceof CoverGroup && this.code2 instanceof CoverGroup) {
            if (this.code1 == this.code2) {
                HashSet<Polygon> ever = new HashSet<Polygon>();
                for (Polygon p1 : buffers) {
                    if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code1).contains((Cover)((Composition)p1.getUserData()).getAttribute("cover").getValue(t))) continue;
                    ever.add(p1);
                    for (Polygon p2 : buffers) {
                        if (ever.contains(p2) || !((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code2).contains((Cover)((Composition)p2.getUserData()).getAttribute("cover").getValue(t)) || !p1.intersects((Geometry)p2)) continue;
                        Geometry i = this.getIntersection(point, p1, p2);
                        if (i instanceof Polygon || i instanceof MultiPolygon) {
                            this.value += i.getLength() / 2.0;
                            continue;
                        }
                        System.out.println(i.getClass());
                    }
                }
            } else {
                for (Polygon p1 : buffers) {
                    if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code1).contains((Cover)((Composition)p1.getUserData()).getAttribute("cover").getValue(t))) continue;
                    for (Polygon p2 : buffers) {
                        if (!((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code2).contains((Cover)((Composition)p2.getUserData()).getAttribute("cover").getValue(t)) || !p1.intersects((Geometry)p2)) continue;
                        Geometry i = this.getIntersection(point, p1, p2);
                        if (i instanceof Polygon || i instanceof MultiPolygon) {
                            this.value += i.getLength() / 2.0;
                            continue;
                        }
                        System.out.println(i.getClass());
                    }
                }
            }
        } else if (this.code1 instanceof CoverGroup) {
            for (Polygon p1 : buffers) {
                if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((CoverGroup)this.code1).contains((Cover)((Composition)p1.getUserData()).getAttribute("cover").getValue(t))) continue;
                for (Polygon p2 : buffers) {
                    if (!((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p2.getUserData()).getAttribute("cover").getValue(t).equals(this.code2) || !p1.intersects((Geometry)p2)) continue;
                    Geometry i = this.getIntersection(point, p1, p2);
                    if (i instanceof Polygon || i instanceof MultiPolygon) {
                        this.value += i.getLength() / 2.0;
                        continue;
                    }
                    System.out.println(i.getClass());
                }
            }
        } else if (this.code1 == this.code2) {
            HashSet<Polygon> ever = new HashSet<Polygon>();
            for (Polygon p1 : buffers) {
                if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p1.getUserData()).getAttribute("cover").getValue(t).equals(this.code1)) continue;
                ever.add(p1);
                for (Polygon p2 : buffers) {
                    if (ever.contains(p2) || !((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p2.getUserData()).getAttribute("cover").getValue(t).equals(this.code1) || !p1.intersects((Geometry)p2)) continue;
                    Geometry i = this.getIntersection(point, p1, p2);
                    if (i instanceof Polygon || i instanceof MultiPolygon) {
                        this.value += i.getLength() / 2.0;
                        continue;
                    }
                    System.out.println(i.getClass());
                }
            }
        } else {
            for (Polygon p1 : buffers) {
                if (!((Composition)p1.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p1.getUserData()).getAttribute("cover").getValue(t).equals(this.code1)) continue;
                for (Polygon p2 : buffers) {
                    if (!((Composition)p2.getUserData()).getAttribute("cover").isActive(t) || !((Composition)p2.getUserData()).getAttribute("cover").getValue(t).equals(this.code2) || !p1.intersects((Geometry)p2)) continue;
                    Geometry i = this.getIntersection(point, p1, p2);
                    if (i instanceof Polygon || i instanceof MultiPolygon) {
                        this.value += i.getLength() / 2.0;
                        continue;
                    }
                    System.out.println(i.getClass());
                }
            }
        }
        if (Double.isNaN(this.value)) {
            this.value = Raster.getNoDataValue();
        }
    }
}

