/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.output;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.process.Process;
import fr.inra.sad.bagap.apiland.analysis.process.ProcessState;
import fr.inra.sad.bagap.apiland.analysis.process.metric.AbstractMetricOutput;
import fr.inra.sad.bagap.apiland.analysis.process.metric.Metric;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcess;
import fr.inra.sad.bagap.apiland.analysis.vector.window.WindowVectorAnalysis;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class CsvOutputV
extends AbstractMetricOutput {
    private String file;
    private CsvWriter out;
    private Map<String, Double> values;

    public CsvOutputV(String f) {
        this.file = f;
        this.values = new TreeMap<String, Double>();
        this.flush();
    }

    public String toString() {
        return "csv";
    }

    private void flush() {
        this.values.clear();
    }

    @Override
    public void notify(Analysis a, AnalysisState state) {
        switch (state) {
            case INIT: {
                this.notifyAnalysisInit((WindowVectorAnalysis)a);
                break;
            }
            case RUNNING: {
                this.notifyAnalysisRun((WindowVectorAnalysis)a);
                break;
            }
            case FINISH: {
                this.notifyAnalysisFinish((WindowVectorAnalysis)a);
            }
        }
    }

    private void notifyAnalysisInit(WindowVectorAnalysis a) {
        this.out = new CsvWriter(this.file);
        this.out.setDelimiter(';');
    }

    private void notifyAnalysisRun(WindowVectorAnalysis a) {
        try {
            this.out.write("X");
            this.out.write("Y");
            for (double buffer : a.buffers()) {
                for (VectorMetric vm : a.metrics()) {
                    String entete = vm.getName() + "_" + buffer;
                    this.out.write(entete.replace(".0", ""));
                }
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void notifyAnalysisFinish(WindowVectorAnalysis a) {
        this.out.close();
        this.out = null;
    }

    @Override
    public void notify(Metric m, String metric, double value, Process process) {
        this.values.put(metric, value);
    }

    @Override
    public void notify(Process p, ProcessState state) {
        switch (state) {
            case DONE: {
                this.notifyProcessDone((VectorProcess)p);
            }
        }
    }

    private void notifyProcessDone(VectorProcess p) {
        try {
            this.out.write(p.x() + "");
            this.out.write(p.y() + "");
            for (String v : this.values.keySet()) {
                this.out.write(this.format(this.values.get(v)));
            }
            this.out.endRecord();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.flush();
    }
}

