/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.window;

import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcess;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcessType;
import fr.inra.sad.bagap.apiland.analysis.vector.window.WindowVectorAnalysis;
import fr.inra.sad.bagap.apiland.core.element.DynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class SlidingWindowVectorAnalysis
extends WindowVectorAnalysis {
    private double displacement;
    private STRtree sIndex;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Geometry geomFilter;

    public SlidingWindowVectorAnalysis(DynamicLayer<?> layer, Set<Double> buffers, Set<VectorMetric> metrics, double minRate, Map<String, Set<Object>> filters, Map<String, Set<Object>> unfilters, Geometry geomFilter, double displacement, Instant t, VectorProcessType processType, double minX, double maxX, double minY, double maxY) {
        super(layer, buffers, metrics, minRate, filters, unfilters, t, processType);
        this.displacement = displacement;
        this.geomFilter = geomFilter;
        if (minX == -1.0 && maxX == -1.0 && minY == -1.0 && maxY == -1.0) {
            this.minX = layer.minX();
            this.maxX = layer.maxX();
            this.minY = layer.minY();
            this.maxY = layer.maxY();
        } else {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }
    }

    public double displacement() {
        return this.displacement;
    }

    @Override
    protected void doInit() {
        this.sIndex = new STRtree();
        Iterator ite = this.layer.activeDeepIterator(this.t);
        while (ite.hasNext()) {
            DynamicFeature f = (DynamicFeature)ite.next();
            this.sIndex.insert(f.getGeometry(this.t).get().getJTS().getEnvelopeInternal(), (Object)f);
        }
        this.sIndex.build();
    }

    @Override
    protected void doRun() {
        try {
            int ncols = new Double(Math.floor((this.maxX - this.minX) / this.displacement) + 1.0).intValue();
            int nrows = new Double(Math.floor((this.maxY - this.minY) / this.displacement) + 1.0).intValue();
            WKTReader r = new WKTReader();
            double yorigin = this.maxY - this.minY % this.displacement == 0.0 ? this.minY + Math.floor((this.maxY - this.minY) / this.displacement) * this.displacement : this.minY + (Math.floor((this.maxY - this.minY) / this.displacement) + 1.0) * this.displacement;
            double tempY = -1.0;
            List features = null;
            int modulo = this.getMaxBuffer();
            for (int j = 0; j < nrows; ++j) {
                double x = this.minX + this.displacement / 2.0;
                double y = yorigin - this.displacement / 2.0 - (double)j * this.displacement;
                block3: for (int i = 0; i < ncols; ++i) {
                    x = this.minX + this.displacement / 2.0 + (double)i * this.displacement;
                    Point point = (Point)r.read("POINT (" + x + " " + y + ")");
                    VectorProcess process = this.processType.create(point);
                    if (this.geomFilter == null || point.intersects(this.geomFilter)) {
                        if (tempY == -1.0 || Math.abs(tempY - y) > (double)modulo) {
                            tempY = y;
                            features = this.sIndex.query(new Envelope(new Coordinate(this.minX, y + (double)modulo), new Coordinate(this.maxX, y - (double)(2 * modulo))));
                        }
                        if (this.filters != null) {
                            for (DynamicFeature f : features) {
                                if (!f.getGeometry(this.t).get().getJTS().intersects((Geometry)point)) continue;
                                for (Map.Entry e : this.filters.entrySet()) {
                                    for (Object o : (Set)e.getValue()) {
                                        if (!f.getAttribute((String)e.getKey()).getValue(this.t).equals(o)) continue;
                                        process = this.processType.create(point);
                                        process.calculate(this.buffers, this.metrics, features, this.t);
                                        continue block3;
                                    }
                                }
                            }
                            continue;
                        }
                        process.calculate(this.buffers, this.metrics, features, this.t);
                        continue;
                    }
                    process.unCalculate(this.buffers, this.metrics);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void doClose() {
        this.t = null;
        this.sIndex = null;
    }
}

