/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.analysis.vector.window;

import fr.inra.sad.bagap.apiland.analysis.vector.VectorAnalysis;
import fr.inra.sad.bagap.apiland.analysis.vector.metric.VectorMetric;
import fr.inra.sad.bagap.apiland.analysis.vector.process.VectorProcessType;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class WindowVectorAnalysis
extends VectorAnalysis {
    protected DynamicLayer<?> layer;
    protected VectorProcessType processType;
    protected Set<Double> buffers;
    protected Set<VectorMetric> metrics;
    protected double minRate;
    protected Instant t;
    protected Map<String, Set<Object>> filters;
    protected Map<String, Set<Object>> unfilters;

    public WindowVectorAnalysis(DynamicLayer<?> layer, Set<VectorMetric> metrics, Instant t, VectorProcessType processType) {
        this.layer = layer;
        this.metrics = metrics;
        this.t = t;
        this.processType = processType;
    }

    public WindowVectorAnalysis(DynamicLayer<?> layer, Set<Double> buffers, Set<VectorMetric> metrics, double minRate, Map<String, Set<Object>> filters, Map<String, Set<Object>> unfilters, Instant t, VectorProcessType processType) {
        this.layer = layer;
        this.buffers = buffers;
        this.metrics = metrics;
        this.minRate = minRate;
        if (filters.size() > 0) {
            this.filters = new HashMap<String, Set<Object>>();
            this.filters.putAll(filters);
        }
        if (unfilters.size() > 0) {
            this.unfilters = new HashMap<String, Set<Object>>();
            this.unfilters.putAll(unfilters);
        }
        this.t = t;
        this.processType = processType;
    }

    public DynamicLayer<?> layer() {
        return this.layer;
    }

    public Set<Double> buffers() {
        return this.buffers;
    }

    public Set<VectorMetric> metrics() {
        return this.metrics;
    }

    protected int getMaxBuffer() {
        Iterator<Double> ite = this.buffers.iterator();
        int max = Integer.MIN_VALUE;
        while (ite.hasNext()) {
            double b = ite.next();
            max = Math.max(max, new Double(b).intValue());
        }
        return max;
    }

    public void setTime(Instant t) {
        this.t = t;
    }
}

