/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.capfarm.ConstraintFactoryFromExcel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class CfmUtil {
    private static final String path = "C:/Hugues/modelisation/capfarm/methodo/bergerie/bergerie/Assolement_BN_2017/SIG_BN_2017/";

    public static void main(String[] args) {
    }

    public static void generateParametersFromExcel(String path, String input) {
        new ConstraintFactoryFromExcel(path, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void observeShapefile(String input) {
        String output = input;
        try {
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            sfr.close();
            dfr.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            CfmUtil.copy(input + ".prj", output + ".prj");
        }
    }

    public static void generateHistoric(String input, String colId, String ... colOs) {
        try {
            ShpFiles sf = new ShpFiles(input + ".shp");
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            int posId = -1;
            int posType = -1;
            HashMap<String, Integer> pos = new HashMap<String, Integer>();
            for (int i = 0; i < dfr.getHeader().getNumFields(); ++i) {
                if (dfr.getHeader().getFieldName(i).equalsIgnoreCase(colId)) {
                    posId = i;
                }
                if (dfr.getHeader().getFieldName(i).equalsIgnoreCase("type")) {
                    posType = i;
                }
                for (String col : colOs) {
                    if (!dfr.getHeader().getFieldName(i).equalsIgnoreCase(col)) continue;
                    pos.put(col, i);
                }
            }
            CsvWriter cw = new CsvWriter(input + "_historic.csv");
            cw.setDelimiter(';');
            cw.write("parcel");
            cw.write("historic");
            cw.endRecord();
            while (dfr.hasNext()) {
                Object[] entry = dfr.readEntry();
                if (!((String)entry[posType]).equalsIgnoreCase("parcel")) continue;
                cw.write(entry[posId] + "");
                StringBuffer sb = new StringBuffer();
                for (String col : colOs) {
                    sb.append(entry[(Integer)pos.get(col)]);
                    sb.append('-');
                }
                sb.deleteCharAt(sb.length() - 1);
                cw.write(sb.toString());
                cw.endRecord();
            }
            cw.close();
            dfr.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
    }

    public static void generateShapefile(String input, String codeFarm) {
        CfmUtil.generateShapefile(input, codeFarm, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateShapefile(String input, String codeFarm, int startIndex) {
        String output = input + "_cfm";
        try (FileOutputStream fos = new FileOutputStream(output + ".dbf");
             FileOutputStream shp = new FileOutputStream(output + ".shp");
             FileOutputStream shx = new FileOutputStream(output + ".shx");){
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(dfr.getHeader().getNumRecords());
            header.addColumn("id", 'c', 8, 0);
            header.addColumn("area", 'c', 2, 0);
            header.addColumn("type", 'c', 8, 0);
            header.addColumn("facility", 'c', 20, 0);
            header.addColumn("farm", 'c', 8, 0);
            for (int i = 0; i < dfr.getHeader().getNumFields(); ++i) {
                header.addColumn(dfr.getHeader().getFieldName(i), 'c', 20, 0);
            }
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(sfr.getHeader().minX(), sfr.getHeader().maxX(), sfr.getHeader().minY(), sfr.getHeader().maxY()), ShapeType.POLYGON, dfr.getHeader().getNumRecords(), 1000000);
            Object[] entry = new Object[header.getNumFields()];
            int id = startIndex;
            while (sfr.hasNext()) {
                Object[] data = dfr.readEntry();
                entry[0] = id++;
                entry[1] = "AA";
                entry[2] = "parcel";
                entry[3] = "";
                entry[4] = codeFarm;
                for (int i = 5; i < header.getNumFields(); ++i) {
                    entry[i] = data[i - 5];
                }
                Geometry g = (Geometry)sfr.nextRecord().shape();
                sfw.writeGeometry(g);
                dfw.write(entry);
            }
            sfr.close();
            dfr.close();
            dfw.close();
            sfw.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            CfmUtil.copy(input + ".prj", output + ".prj");
        }
    }

    public static void generateShapefileWithID(String input, String idColumnName) {
        CfmUtil.generateShapefileWithID(input, idColumnName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateShapefileWithID(String input, String idColumnName, int startIndex) {
        String output = input + "_cfm";
        try (FileOutputStream fos = new FileOutputStream(output + ".dbf");
             FileOutputStream shp = new FileOutputStream(output + ".shp");
             FileOutputStream shx = new FileOutputStream(output + ".shx");){
            int columnNameNb;
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            for (columnNameNb = 0; columnNameNb < dfr.getHeader().getNumFields(); ++columnNameNb) {
                String tempColmnName = dfr.getHeader().getFieldName(columnNameNb);
                System.out.println(tempColmnName);
                if (tempColmnName.equalsIgnoreCase(idColumnName)) break;
            }
            DbaseFileHeader header = new DbaseFileHeader();
            header.setNumRecords(dfr.getHeader().getNumRecords());
            header.addColumn("id", 'c', 8, 0);
            header.addColumn("area", 'c', 2, 0);
            header.addColumn("type", 'c', 8, 0);
            header.addColumn("facility", 'c', 20, 0);
            header.addColumn("farm", 'c', 8, 0);
            for (int i = 0; i < dfr.getHeader().getNumFields(); ++i) {
                header.addColumn(dfr.getHeader().getFieldName(i), 'c', 20, 0);
            }
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(sfr.getHeader().minX(), sfr.getHeader().maxX(), sfr.getHeader().minY(), sfr.getHeader().maxY()), ShapeType.POLYGON, dfr.getHeader().getNumRecords(), 1000000);
            Object[] entry = new Object[header.getNumFields()];
            int id = startIndex;
            while (sfr.hasNext()) {
                Object[] data = dfr.readEntry();
                entry[0] = id++;
                entry[1] = "AA";
                entry[2] = "parcel";
                entry[3] = "";
                entry[4] = data[columnNameNb];
                for (int i = 5; i < header.getNumFields(); ++i) {
                    entry[i] = data[i - 5];
                }
                Geometry g = (Geometry)sfr.nextRecord().shape();
                sfw.writeGeometry(g);
                dfw.write(entry);
            }
            sfr.close();
            dfr.close();
            dfw.close();
            sfw.close();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            CfmUtil.copy(input + ".prj", output + ".prj");
        }
    }

    public static void copy(String sourceFile, String destFile) {
        try (FileInputStream input = new FileInputStream(sourceFile);
             FileOutputStream output = new FileOutputStream(destFile);){
            int len;
            byte[] buf = new byte[8192];
            while ((len = ((InputStream)input).read(buf)) >= 0) {
                ((OutputStream)output).write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

