/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class SiteSelector {
    private static String path = "C:/Hugues/modelisation/capfarm/methodo/fond_de_carte/RPG/2014/";
    private static String input = path + "RPG_Robillard";
    private static String attributEA = "ILOTS-AN_6";
    private static String name = "robillard";
    private static String attributCommune = "COMMUNE_IL";
    private static double codeCommune = 35104.0;
    private static double x = 479800.0;
    private static double y = 6880480.0;
    private static double rayon = 3000.0;
    private static double minFarmArea = 5.0;
    private static double minX;
    private static double maxX;
    private static double minY;
    private static double maxY;
    private static DbaseFileHeader header;

    public static void main(String[] args) {
        SiteSelector.getEAFromBuffer();
    }

    private static void getEAFromBuffer() {
        Set<String> eas = SiteSelector.getExploitationsFromBuffer();
        Set<Polygon> ilots = SiteSelector.getIlots(eas);
        SiteSelector.writeIlots(ilots);
        SiteSelector.exportBuffer();
    }

    private static Set<String> getExploitationsFromBuffer() {
        TreeSet<String> eas = new TreeSet<String>();
        TreeMap areas = new TreeMap();
        try {
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            header = dfr.getHeader();
            int indexEA = -1;
            for (int i = 0; i < header.getNumFields(); ++i) {
                if (!header.getFieldName(i).equalsIgnoreCase(attributEA)) continue;
                indexEA = i;
            }
            WKTReader wkt = new WKTReader();
            Polygon zone = (Polygon)((Point)wkt.read("POINT (" + x + " " + y + ")")).buffer(rayon);
            while (sfr.hasNext()) {
                Polygon p = (Polygon)((MultiPolygon)sfr.nextRecord().shape()).getGeometryN(0);
                Object[] entry = dfr.readEntry();
                p.setUserData((Object)entry);
                if (!p.intersects((Geometry)zone)) continue;
                if (!areas.containsKey(entry[indexEA])) {
                    areas.put((String)entry[indexEA], new HashSet());
                }
                ((Set)areas.get((String)entry[indexEA])).add(p);
            }
            sfr.close();
            dfr.close();
            int nbTooSmallEA = 0;
            double totalArea = 0.0;
            double rejectArea = 0.0;
            for (Map.Entry e : areas.entrySet()) {
                double area = 0.0;
                String code = "";
                for (Polygon p : (Set)e.getValue()) {
                    area += p.intersection((Geometry)zone).getArea();
                    code = (String)((Object[])p.getUserData())[indexEA];
                }
                if (area >= minFarmArea * 10000.0) {
                    eas.add(code + "");
                    totalArea += area;
                    System.out.println("EA : " + code + ", surface cumul\ufffde = " + area);
                    continue;
                }
                ++nbTooSmallEA;
                rejectArea += area;
                System.out.println("rejet\ufffde : " + code + ", surface cumul\ufffde = " + area);
            }
            System.out.println("nombre d'exploitations concern\ufffdes : " + eas.size() + ", nombre d'exploitations rejet\ufffdes : " + nbTooSmallEA);
            System.out.println("taux de couverture agricole trait\ufffde : " + totalArea * 100.0 / zone.getArea() + "%");
            System.out.println("taux de couverture agricole rejet\ufffde : " + rejectArea * 100.0 / zone.getArea() + "%");
            System.out.println("taux de couverture agricole : " + (totalArea + rejectArea) * 100.0 / zone.getArea() + "%");
            System.out.println("taux de couverture non agricole : " + (100.0 - (totalArea + rejectArea) * 100.0 / zone.getArea()) + "%");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return eas;
    }

    private static Set<Polygon> getIlots(Set<String> eas) {
        TreeSet<Polygon> ilots = new TreeSet<Polygon>();
        try {
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            minX = Double.MAX_VALUE;
            maxX = Double.MIN_VALUE;
            minY = Double.MAX_VALUE;
            maxY = Double.MIN_VALUE;
            int indexEA = -1;
            for (int i = 0; i < header.getNumFields(); ++i) {
                if (!header.getFieldName(i).equalsIgnoreCase(attributEA)) continue;
                indexEA = i;
                break;
            }
            while (sfr.hasNext()) {
                Polygon p = (Polygon)((MultiPolygon)sfr.nextRecord().shape()).getGeometryN(0);
                Object[] entry = dfr.readEntry();
                if (!eas.contains(entry[indexEA] + "")) continue;
                p.setUserData((Object)entry);
                ilots.add(p);
                minX = Math.min(minX, p.getEnvelopeInternal().getMinX());
                maxX = Math.max(maxX, p.getEnvelopeInternal().getMaxX());
                minY = Math.min(minY, p.getEnvelopeInternal().getMinY());
                maxY = Math.max(maxY, p.getEnvelopeInternal().getMaxY());
            }
            sfr.close();
            dfr.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ilots;
    }

    private static void writeIlots(Set<Polygon> ilots) {
        String output = path + name + "_" + rayon + "_" + minFarmArea;
        try (FileOutputStream fos = new FileOutputStream(output + ".dbf");
             FileOutputStream shp = new FileOutputStream(output + ".shp");
             FileOutputStream shx = new FileOutputStream(output + ".shx");){
            header.setNumRecords(ilots.size());
            DbaseFileWriter dfw = new DbaseFileWriter(header, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(minX, maxX, minY, maxY), ShapeType.POLYGON, ilots.size(), 1000000);
            for (Polygon p : ilots) {
                sfw.writeGeometry((Geometry)p);
                dfw.write((Object[])p.getUserData());
            }
            dfw.close();
            sfw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SiteSelector.copyFile(input + ".prj", output + ".prj");
    }

    private static void exportBuffer() {
        String output = path + "buffer_" + rayon + "_" + x + "-" + y;
        try (FileOutputStream fos = new FileOutputStream(output + ".dbf");
             FileOutputStream shp = new FileOutputStream(output + ".shp");
             FileOutputStream shx = new FileOutputStream(output + ".shx");){
            WKTReader wkt = new WKTReader();
            Polygon zone = (Polygon)((Point)wkt.read("POINT (" + x + " " + y + ")")).buffer(rayon);
            DbaseFileHeader h = new DbaseFileHeader();
            h.setNumRecords(1);
            DbaseFileWriter dfw = new DbaseFileWriter(h, (WritableByteChannel)fos.getChannel());
            ShapefileWriter sfw = new ShapefileWriter(shp.getChannel(), shx.getChannel());
            sfw.writeHeaders(new Envelope(zone.getEnvelopeInternal().getMinX(), zone.getEnvelopeInternal().getMaxX(), zone.getEnvelopeInternal().getMinY(), zone.getEnvelopeInternal().getMaxY()), ShapeType.POLYGON, 1, 1000000);
            sfw.writeGeometry((Geometry)zone);
            dfw.write(new Object[0]);
            dfw.close();
            sfw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        SiteSelector.copyFile(input + ".prj", output + ".prj");
    }

    private static void getEAFromCommune() {
        Set<String> eas = SiteSelector.getExploitationsFromCode();
        Set<Polygon> ilots = SiteSelector.getIlots(eas);
        SiteSelector.writeIlots(ilots);
    }

    private static Set<String> getExploitationsFromCode() {
        TreeSet<String> eas = new TreeSet<String>();
        try {
            ShpFiles sf = new ShpFiles(input + ".shp");
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            header = dfr.getHeader();
            minX = sfr.getHeader().minX();
            maxX = sfr.getHeader().maxX();
            minY = sfr.getHeader().minY();
            maxY = sfr.getHeader().maxY();
            int indexEA = -1;
            int indexCommune = -1;
            for (int i = 0; i < header.getNumFields(); ++i) {
                if (header.getFieldName(i).equalsIgnoreCase(attributEA)) {
                    indexEA = i;
                }
                if (!header.getFieldName(i).equalsIgnoreCase(attributCommune)) continue;
                indexCommune = i;
            }
            while (sfr.hasNext()) {
                Polygon p = (Polygon)((MultiPolygon)sfr.nextRecord().shape()).getGeometryN(0);
                Object[] entry = dfr.readEntry();
                if ((Double)entry[indexCommune] != codeCommune) continue;
                eas.add((String)entry[indexEA]);
            }
            System.out.println("nombre d'exploitation concern\ufffdes : " + eas.size());
            sfr.close();
            dfr.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return eas;
    }

    public static String getPath() {
        return path;
    }

    public static void setPath(String path) {
        SiteSelector.path = path;
    }

    public static String getInput() {
        return input;
    }

    public static void setInput(String input) {
        SiteSelector.input = input;
    }

    public static String getAttributEA() {
        return attributEA;
    }

    public static void setAttributEA(String attributEA) {
        SiteSelector.attributEA = attributEA;
    }

    public static String getName() {
        return name;
    }

    public static void setName(String name) {
        SiteSelector.name = name;
    }

    public static String getAttributCommune() {
        return attributCommune;
    }

    public static void setAttributCommune(String attributCommune) {
        SiteSelector.attributCommune = attributCommune;
    }

    public static double getCodeCommune() {
        return codeCommune;
    }

    public static void setCodeCommune(double codeCommune) {
        SiteSelector.codeCommune = codeCommune;
    }

    public static double getRayon() {
        return rayon;
    }

    public static void setRayon(double rayon) {
        SiteSelector.rayon = rayon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(String source, String dest) {
        try (FileInputStream sourceFile = new FileInputStream(new File(source));
             FileOutputStream destinationFile = null;){
            int nbLecture;
            destinationFile = new FileOutputStream(new File(dest));
            byte[] buffer = new byte[524288];
            while ((nbLecture = sourceFile.read(buffer)) != -1) {
                destinationFile.write(buffer, 0, nbLecture);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

