/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.csp;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Map;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;

public class FixedCoverAllocationProblem
extends CoverAllocationProblem {
    private Map<Parcel, CoverUnit> fixed;

    public FixedCoverAllocationProblem(CoverAllocator allocator, Instant t, Map<Parcel, CoverUnit> fixed) {
        super(allocator, t);
        this.fixed = fixed;
    }

    @Override
    protected void postConstraints() {
        super.postConstraints();
        for (Map.Entry<Parcel, Integer> p : this.parcels().entrySet()) {
            int ic = this.covers().get(this.fixed.get(p.getKey()));
            this.solver().post(ICF.arithm((IntVar)this.coversAndParcels(ic, p.getValue()), (String)"=", (int)1));
        }
    }

    @Override
    protected boolean solve() {
        if (this.solver.findSolution()) {
            block0: for (Parcel p : this.parcels().keySet()) {
                int ip = this.parcels().get(p);
                if (this.parcelsImplantedCoverContinue[ip].getValue() != 0) continue;
                for (Cover cover : this.covers().keySet()) {
                    int ic = this.covers().get(cover);
                    if (this.coversAndParcels[ic][ip].getValue() != 1) continue;
                    p.getAttribute("cover").setValue(this.time(), cover);
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }
}

