/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverManager;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Covering;
import java.io.File;
import java.io.IOException;

public class CoverFactory {
    public static void init(String types) {
        File folder = new File(types);
        for (File f : folder.listFiles()) {
            try {
                CsvReader cr = new CsvReader(f.toString() + "/covers.txt");
                cr.setDelimiter(';');
                cr.readHeaders();
                while (cr.readRecord()) {
                    CoverManager.getCoverUnit(cr.get("code"), cr.get("name"));
                }
                cr.close();
                if (!new File(f.toString() + "/groups.txt").exists()) continue;
                cr = new CsvReader(f + "/groups.txt");
                cr.setDelimiter(';');
                cr.readHeaders();
                while (cr.readRecord()) {
                    CoverManager.getCoverGroup(cr.get("code"), cr.get("name"), cr.get("covers"));
                }
                cr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CsvReader.FinalizedException e) {
                e.printStackTrace();
            }
            catch (CsvReader.CatastrophicException e) {
                e.printStackTrace();
            }
        }
    }

    public static void init(Covering system, String coverFile) {
        CoverFactory.init(system, coverFile, null);
    }

    public static void init(Covering system, String coverFile, String groupFile) {
        try {
            CsvReader cr = new CsvReader(coverFile);
            cr.setDelimiter(';');
            cr.readHeaders();
            while (cr.readRecord()) {
                system.addCover(CoverManager.getCoverUnit(cr.get("code"), cr.get("name")));
            }
            cr.close();
            if (groupFile != null && !groupFile.equalsIgnoreCase("") && new File(groupFile).exists()) {
                cr = new CsvReader(groupFile);
                cr.setDelimiter(';');
                cr.readHeaders();
                while (cr.readRecord()) {
                    system.addCover(CoverManager.getCoverGroup(cr.get("code"), cr.get("name"), cr.get("covers")));
                }
                cr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CsvReader.FinalizedException e) {
            e.printStackTrace();
        }
        catch (CsvReader.CatastrophicException e) {
            e.printStackTrace();
        }
    }

    public static void export(String coverFile, String groupFile) {
        CoverFactory.exportCoverUnits(coverFile);
        CoverFactory.exportCoverGroups(groupFile);
    }

    public static void exportCoverUnits(String coverFile) {
        try {
            CsvWriter cw = new CsvWriter(coverFile);
            cw.setDelimiter(';');
            cw.write("code");
            cw.write("name");
            cw.endRecord();
            for (CoverUnit cu : CoverManager.coverUnits()) {
                cw.write(cu.getCode());
                cw.write(cu.getName());
                cw.endRecord();
            }
            cw.close();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportCoverGroups(String groupFile) {
        try {
            CsvWriter cw = new CsvWriter(groupFile);
            cw.setDelimiter(';');
            cw.write("code");
            cw.write("name");
            cw.write("covers");
            cw.endRecord();
            for (CoverGroup cg : CoverManager.coverGroups()) {
                cw.write(cg.getCode());
                cw.write(cg.getName());
                cw.write(cg.getCovers().toString().replaceAll("\\[", "{").replaceAll("\\]", "}").replaceAll(" ", ""));
                cw.endRecord();
            }
            cw.close();
        }
        catch (CsvWriter.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }
}

