/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.ConstraintSystem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.AgriculturalArea;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FarmsAllocator
implements CoverAllocator {
    private String code;
    private ConstraintSystem system;
    private AgriculturalArea territory;

    public FarmsAllocator(String code) {
        this.code = code;
        this.system = new ConstraintSystem(code);
    }

    @Override
    public void setTerritory(DynamicElement element) {
        this.territory = (AgriculturalArea)element;
    }

    @Override
    public void addCover(Cover c) {
        this.system.addCover(c);
    }

    @Override
    public void addCovers(Collection<Cover> covers) {
        this.system.addCovers(covers);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public DynamicElement getTerritory() {
        return this.territory;
    }

    @Override
    public int getArea() {
        return this.territory.totalParcelsArea();
    }

    @Override
    public Set<CoverUnit> coverUnits() {
        return this.system.coverUnits();
    }

    @Override
    public CoverUnit getCoverUnit(String code) {
        return this.system.getCoverUnit(code);
    }

    @Override
    public Set<CoverGroup> coverGroups() {
        return this.system.coverGroups();
    }

    @Override
    public Set<Parcel> parcels() {
        return this.territory.parcels();
    }

    @Override
    public Parcel parcel(String id) {
        return this.territory.parcel(id);
    }

    @Override
    public Set<CoverAllocationConstraint<?, ?>> getConstraints() {
        return this.system.getConstraints();
    }

    @Override
    public int totalParcelsArea() {
        return this.territory.totalParcelsArea();
    }

    @Override
    public int totalEdgesLength() {
        return this.territory.totalEdgesLength();
    }

    @Override
    public int[] edgesLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addConstraint(CoverAllocationConstraint<?, ?> constraint) {
        this.system.addConstraint(constraint);
        constraint.setAllocator(this);
    }

    @Override
    public int getDistanceFromFacilitiesToParcel(String facilities, Parcel parcel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParcels() {
        this.territory.clearParcels();
    }

    @Override
    public ConstraintSystem getConstraintSystem() {
        return this.system;
    }

    @Override
    public void clearConstraintSystem() {
        this.system = new ConstraintSystem(this.code);
    }

    @Override
    public void checkConstraintSystem(Instant start, Instant end, boolean verbose) {
        for (CoverAllocationConstraint<?, ?> ca : this.system.getConstraints()) {
            ca.check(start, end, true);
        }
    }

    @Override
    public boolean hasMemory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMemory(int memory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMemory(boolean memory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Parcel, CoverUnit> getSolution() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSolution(Map<Parcel, CoverUnit> solution) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<CoverUnit> historicalCovers() {
        return null;
    }
}

