/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.io.IOException;
import java.util.HashMap;

public class FixedFactory {
    public static void init(Farm farm, Instant start) {
        if (farm.hasSolution()) {
            try {
                CsvReader cr = new CsvReader(farm.getFixFile());
                cr.setDelimiter(';');
                cr.readHeaders();
                HashMap<Parcel, CoverUnit> fixed = new HashMap<Parcel, CoverUnit>();
                while (cr.readRecord()) {
                    String parcel = cr.get("parcel");
                    String cover = cr.get("cover");
                    fixed.put(farm.parcel(parcel), (CoverUnit)Cover.get(cover));
                }
                farm.setSolution(fixed);
                cr.close();
            }
            catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

