/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.CAPFarm;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverGroup;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.GenericConstraintSystem;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintLocationListener;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.DelayConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.DistanceBetweenCoversConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.DistanceFromFacilitiesConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.DurationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.GenericConstraintBuilder;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.GenericCoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.LinkedFieldsConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.LocationLexer;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.LocationParser;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.NextCoverConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.OnBooleanConditionConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.OnLocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.OnNumericConditionConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ParcelAreaConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ParcelCountConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.RepetitionConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.SpatialPatternConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.TemporalPatternConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.TotalAreaConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.AllDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.AndDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.BoundedDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.NumberDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.SetDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.VariableBooleanDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.VariableValueDomain;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint.ProfitConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint.ProfitVariabilityConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.constraint.WorkConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class ConstraintBuilder {
    private CoverAllocator allocator;
    private String code;
    private Set<Cover> covers = new TreeSet<Cover>();
    private ConstraintType type;
    private ConstraintMode mode;
    private Set<Parcel> location = new TreeSet<Parcel>();
    private String domain;
    private String[] params;
    private GenericConstraintBuilder genericBuilder;
    private boolean hasLocation;
    private boolean checkOnly;

    public ConstraintBuilder(CoverAllocator allocator) {
        this.initCoverAllocator(allocator);
    }

    public void initCoverAllocator(CoverAllocator allocator) {
        this.reset();
        this.allocator = allocator;
        this.genericBuilder = new GenericConstraintBuilder(allocator.getConstraintSystem().getGenericConstraintSystem());
    }

    private void reset() {
        this.code = null;
        this.covers.clear();
        this.type = null;
        this.mode = null;
        this.location.clear();
        this.domain = null;
        this.params = null;
        this.hasLocation = false;
        this.checkOnly = false;
    }

    public void setCode(String code) {
        this.code = code;
        this.genericBuilder.setCode(code);
    }

    public void setCover(String ... covers) {
        if (covers[0].equalsIgnoreCase("EACH")) {
            for (Cover cover : this.allocator.coverUnits()) {
                this.covers.add(cover);
            }
        } else if (covers[0].equalsIgnoreCase("ALL")) {
            for (Cover cover : this.allocator.coverUnits()) {
                this.covers.add(cover);
            }
        } else if (covers[0].equalsIgnoreCase("EXCEPT")) {
            for (Cover cover : this.allocator.coverUnits()) {
                boolean ok = true;
                for (int i = 1; i < covers.length; ++i) {
                    if (!cover.getCode().equalsIgnoreCase(covers[i])) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                this.covers.add(cover);
            }
        } else {
            for (String code : covers) {
                if (!Cover.has(code)) {
                    throw new IllegalArgumentException("There is no cover : " + code);
                }
                this.covers.add(Cover.get(code));
            }
        }
        this.genericBuilder.setCover(covers);
    }

    public void setType(ConstraintType type) {
        this.type = type;
        this.genericBuilder.setType(type);
    }

    public void setType(String type) {
        this.type = ConstraintType.valueOf(type);
        this.genericBuilder.setType(type);
    }

    public void setMode(ConstraintMode mode) {
        this.mode = mode;
        this.genericBuilder.setMode(mode);
    }

    public void setMode(String mode) {
        this.mode = ConstraintMode.valueOf(mode);
        this.genericBuilder.setMode(mode);
    }

    public void setLocation(String location) {
        this.hasLocation = true;
        LocationParser parser = new LocationParser((TokenStream)new CommonTokenStream((TokenSource)new LocationLexer((CharStream)new ANTLRInputStream(location))));
        ConstraintLocationListener listener = new ConstraintLocationListener(this.allocator);
        new ParseTreeWalker().walk((ParseTreeListener)listener, (ParseTree)parser.evaluate());
        if (!listener.hasError()) {
            this.location.addAll(listener.buildLocation());
        } else {
            System.err.println("error in location constraint : " + listener.toStringError());
        }
        this.genericBuilder.setLocation(location);
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.genericBuilder.setDomain(domain);
    }

    public void setParams(String ... params) {
        this.params = params;
        this.genericBuilder.setParams(params);
    }

    public void setCheckOnly(boolean check) {
        this.checkOnly = check;
    }

    public void build(GenericConstraintSystem system) {
        this.allocator.addCovers(system.getCovers());
        for (GenericCoverAllocationConstraint gc : system.getConstraints()) {
            this.setCode(gc.getCode());
            this.setType(gc.getType());
            this.setMode(gc.getMode());
            this.setCover(gc.getCovers());
            this.setLocation(gc.getLocation());
            this.setDomain(gc.getDomain());
            this.setParams(gc.getParams());
            this.build();
        }
        this.allocator.getConstraintSystem().setGenericConstraintSystem(system);
    }

    public void build() {
        this.initBuild();
        switch (this.type) {
            case ParcelArea: {
                this.initParcelAreaConstraints();
                break;
            }
            case ParcelCount: {
                this.initParcelCountConstraints();
                break;
            }
            case TotalArea: {
                this.initTotalAreaConstraints();
                break;
            }
            case DistanceFromFacilities: {
                this.initDistanceFromFacilitiesConstraints();
                break;
            }
            case DistanceBetweenCovers: {
                this.initDistanceBetweenCoversConstraints();
                break;
            }
            case OnBooleanCondition: {
                this.initOnBooleanConditionConstraints();
                break;
            }
            case OnNumericCondition: {
                this.initOnNumericConditionConstraints();
                break;
            }
            case Delay: {
                this.initDelayConstraints();
                break;
            }
            case Duration: {
                this.initDurationConstraints();
                break;
            }
            case Repetition: {
                this.initRepetitionConstraints();
                break;
            }
            case NextCover: {
                this.initNextCoverConstraints();
                break;
            }
            case TemporalPattern: {
                this.initTemporalPatternConstraints();
                break;
            }
            case SpatialPattern: {
                this.initSpatialPatternConstraints();
                break;
            }
            case LinkedFields: {
                this.initLinkedFieldsConstraints();
                break;
            }
            case OnLocation: {
                this.initOnLocationConstraints();
                break;
            }
            case Profit: {
                this.initProfitConstraints();
                break;
            }
            case Work: {
                this.initWorkConstraints();
                break;
            }
            case ProfitVariability: {
                this.initProfitVariabilityConstraints();
                break;
            }
            default: {
                throw new IllegalArgumentException("constraint type '" + (Object)((Object)this.type) + "' not implemented yet.");
            }
        }
        this.reset();
        this.genericBuilder.build();
    }

    private void initBuild() {
        if (!this.hasLocation) {
            this.setLocation("");
        }
        if (this.covers.size() == 0) {
            this.setCover("ALL");
        }
        if (this.mode == null) {
            this.setMode(ConstraintMode.ONLY);
        }
    }

    private void initParcelAreaConstraints() {
        Domain<Integer, Integer> domain = this.buildAreaDomain();
        ParcelAreaConstraint constraint = new ParcelAreaConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initParcelCountConstraints() {
        Domain<Integer, Integer> domain = this.buildIntDomain(1.0);
        ParcelCountConstraint constraint = new ParcelCountConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initTotalAreaConstraints() {
        int locationArea = 0;
        for (Parcel p : this.location) {
            locationArea += p.getArea();
        }
        Domain<Integer, Integer> domain = this.buildAreaDomain(locationArea);
        TotalAreaConstraint constraint = new TotalAreaConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initDistanceFromFacilitiesConstraints() {
        Domain<Integer, Integer> domain = this.buildDistanceDomain();
        DistanceFromFacilitiesConstraint constraint = new DistanceFromFacilitiesConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain, this.params[0]);
        this.allocator.addConstraint(constraint);
    }

    private void initDistanceBetweenCoversConstraints() {
        TreeSet<Cover> targets = new TreeSet<Cover>();
        for (String p : this.params) {
            targets.add(Cover.get(p));
        }
        Domain<Integer, Integer> domain = this.buildDistanceDomain();
        DistanceBetweenCoversConstraint constraint = new DistanceBetweenCoversConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain, targets);
        this.allocator.addConstraint(constraint);
    }

    private void initOnBooleanConditionConstraints() {
        Domain<Boolean, Parcel> domain = this.buildBooleanDomain();
        OnBooleanConditionConstraint constraint = new OnBooleanConditionConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initOnNumericConditionConstraints() {
        Domain<Double, Parcel> domain = this.buildDoubleDomain();
        OnNumericConditionConstraint constraint = new OnNumericConditionConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initDelayConstraints() {
        TreeSet<Cover> targets = new TreeSet<Cover>();
        if (this.params[0] != null) {
            targets.add(Cover.get(this.params[0]));
        } else {
            targets.addAll(this.covers);
        }
        Domain<Integer, Integer> domain = this.buildIntDomain(1.0);
        DelayConstraint constraint = new DelayConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain, targets);
        this.allocator.addConstraint(constraint);
    }

    private void initDurationConstraints() {
        if (this.params == null) {
            this.setParams("middle");
        }
        boolean hasMax = this.hasMax();
        Domain<Integer, Integer> domain = this.buildBoundedDomain(1.0, 1, 12);
        DurationConstraint constraint = new DurationConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain, this.params[0], hasMax);
        this.allocator.addConstraint(constraint);
    }

    private void initRepetitionConstraints() {
        if (this.params == null) {
            this.setParams("middle");
        }
        boolean hasMax = this.hasMax();
        Domain<Integer, Integer> domain = this.buildBoundedDomain(1.0, 0, 12);
        RepetitionConstraint constraint = null;
        if (this.genericBuilder.getCover().equalsIgnoreCase("EACH")) {
            TreeSet<Cover> cov = new TreeSet<Cover>();
            for (Cover c : this.covers) {
                cov.clear();
                cov.add(c);
                constraint = new RepetitionConstraint(this.code + "_" + c.getCode(), this.checkOnly, this.mode, cov, this.location, domain, this.params[0], hasMax);
                this.allocator.addConstraint(constraint);
            }
        } else {
            constraint = new RepetitionConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain, this.params[0], hasMax);
            this.allocator.addConstraint(constraint);
        }
    }

    private boolean hasMax() {
        if (this.domain.contains("[") || this.domain.contains("]")) {
            String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").split(",", 2);
            return !d[1].equalsIgnoreCase("");
        }
        return true;
    }

    private void initNextCoverConstraints() {
        if (this.domain != null && !this.domain.equalsIgnoreCase("")) {
            Domain<CoverUnit, CoverUnit> domain = this.buildCoverDomain();
            NextCoverConstraint constraint = new NextCoverConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
            this.allocator.addConstraint(constraint);
        } else if (this.params != null || !new File(this.params[0]).exists()) {
            try {
                CoverAllocationConstraint constraint;
                CsvReader cr = new CsvReader(this.params[0]);
                cr.setDelimiter(';');
                cr.readHeaders();
                TreeSet<Cover> cov = new TreeSet<Cover>();
                TreeSet<Cover> total = new TreeSet<Cover>();
                while (cr.readRecord()) {
                    cov.clear();
                    CoverUnit prec = this.allocator.getCoverUnit(cr.get("previous"));
                    cov.add(prec);
                    total.add(prec);
                    TreeSet<CoverUnit> next = new TreeSet<CoverUnit>();
                    for (int c = 1; c < cr.getHeaderCount(); ++c) {
                        if (!cr.get(c).equals("1")) continue;
                        next.add(this.allocator.getCoverUnit(cr.getHeaders()[c]));
                    }
                    if (next.size() == this.allocator.coverUnits().size()) continue;
                    constraint = new NextCoverConstraint(this.code + "_" + prec.getCode(), this.checkOnly, this.mode, cov, this.location, new SetDomain<CoverUnit>(next));
                    this.allocator.addConstraint(constraint);
                }
                constraint = new OnLocationConstraint(new File(this.params[0]).getName(), false, ConstraintMode.ALWAYS, total, this.location);
                this.allocator.addConstraint(constraint);
                cr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CsvReader.FinalizedException e) {
                e.printStackTrace();
            }
            catch (CsvReader.CatastrophicException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("initialization problem for NextCover constraint");
        }
    }

    private void initTemporalPatternConstraints() {
        String[] p = this.params[0].split("-");
        TreeMap<Integer, Cover> pc = new TreeMap<Integer, Cover>();
        for (int i = 0; i < p.length; ++i) {
            if (p[i].equalsIgnoreCase("X")) continue;
            if (Cover.has(p[i])) {
                if (p[i].startsWith("~")) {
                    pc.put(-1 * (p.length - 1 - i), Cover.get(p[i].replace("~", "")));
                    continue;
                }
                pc.put(p.length - 1 - i, Cover.get(p[i]));
                continue;
            }
            throw new IllegalArgumentException("Cover " + p[i] + " does not exists");
        }
        TemporalPatternConstraint constraint = new TemporalPatternConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, pc);
        this.allocator.addConstraint(constraint);
    }

    private void initSpatialPatternConstraints() {
        Domain<Integer, Integer> domain = this.buildIntDomain(1.0);
        SpatialPatternConstraint constraint = new SpatialPatternConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initLinkedFieldsConstraints() {
        if (this.mode == ConstraintMode.ONLY) {
            this.setMode(ConstraintMode.ALWAYS);
        }
        LinkedFieldsConstraint constraint = new LinkedFieldsConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location);
        this.allocator.addConstraint(constraint);
    }

    private void initOnLocationConstraints() {
        OnLocationConstraint constraint = new OnLocationConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location);
        this.allocator.addConstraint(constraint);
    }

    private void initProfitConstraints() {
        Domain<Integer, Integer> domain = this.buildIntDomain(100.0);
        ProfitConstraint constraint = new ProfitConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initProfitVariabilityConstraints() {
        Domain<Integer, Integer> domain = this.buildIntDomain(100.0);
        ProfitVariabilityConstraint constraint = new ProfitVariabilityConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private void initWorkConstraints() {
        Domain<Integer, Integer> domain = this.buildIntDomain(1.0);
        WorkConstraint constraint = new WorkConstraint(this.code, this.checkOnly, this.mode, this.covers, this.location, domain);
        this.allocator.addConstraint(constraint);
    }

    private Set<CoverUnit> getCoverUnits(Set<Cover> covers) {
        HashSet<CoverUnit> coverunits = new HashSet<CoverUnit>();
        for (Cover c : covers) {
            if (c instanceof CoverUnit) {
                coverunits.add((CoverUnit)c);
                continue;
            }
            for (CoverUnit cu : (CoverGroup)c) {
                coverunits.add(cu);
            }
        }
        return coverunits;
    }

    private Domain<CoverUnit, CoverUnit> buildCoverDomain() {
        if (this.domain.startsWith("[") && this.domain.endsWith("]")) {
            this.domain = this.domain.replace("[", "").replace("]", "").replace(" ", "");
            String[] d = this.domain.split(",");
            TreeSet<CoverUnit> targets = new TreeSet<CoverUnit>();
            if (d[0].equalsIgnoreCase("ALL")) {
                for (CoverUnit c : this.allocator.coverUnits()) {
                    targets.add(c);
                }
            } else {
                for (String code : d) {
                    targets.add((CoverUnit)Cover.get(code));
                }
            }
            return new SetDomain<CoverUnit>(targets);
        }
        return null;
    }

    private Domain<Double, Parcel> buildDoubleDomain() {
        if (this.domain.startsWith("[") && this.domain.endsWith("]")) {
            this.domain = this.domain.replace("[", "").replace("]", "").replace(" ", "");
            String op = "";
            if (this.domain.contains("<=")) {
                op = "<=";
            } else if (this.domain.contains(">=")) {
                op = ">=";
            } else if (this.domain.contains("<")) {
                op = "<";
            } else if (this.domain.contains(">")) {
                op = ">";
            } else if (this.domain.contains("!=")) {
                op = "!=";
            } else if (this.domain.contains("=")) {
                op = "=";
            } else {
                throw new IllegalArgumentException(this.domain);
            }
            String[] d = this.domain.split(op, 2);
            return new VariableValueDomain<Double>(d[0], op, Double.parseDouble(d[1]));
        }
        return null;
    }

    private Domain<Integer, Integer> buildAreaDomain() {
        return this.buildAreaDomain(this.allocator.getArea());
    }

    private Domain<Integer, Integer> buildAreaDomain(int locationArea) {
        if (this.domain.contains("min") || this.domain.contains("max")) {
            return this.buildMinMaxAreaDomain();
        }
        if (this.domain.contains("%")) {
            return this.buildPercentDomain(locationArea);
        }
        return this.buildIntDomain(10000.0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Domain<Integer, Integer> buildMinMaxAreaDomain() {
        String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").split(",", 2);
        int area = this.allocator.getArea();
        double v1 = 0.0;
        if (!d[0].equalsIgnoreCase("")) {
            double b;
            String[] dd;
            if (d[0].contains("min")) {
                dd = d[0].replace("min(", "").replace(")", "").split("\\|", 2);
                if (dd[0].contains("%") && !dd[1].contains("%")) {
                    double a = new Double(dd[0].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    b = new Double(dd[1]);
                    v1 = Math.min(a, b *= 10000.0);
                } else {
                    if (!dd[1].contains("%") || dd[0].contains("%")) throw new IllegalArgumentException(this.domain);
                    double a = new Double(dd[1].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    b = new Double(dd[0]);
                    v1 = Math.min(a, b *= 10000.0);
                }
            } else if (d[0].contains("max")) {
                dd = d[0].replace("max(", "").replace(")", "").split("\\|", 2);
                if (dd[0].contains("%") && !dd[1].contains("%")) {
                    double a = new Double(dd[0].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    b = new Double(dd[1]);
                    v1 = Math.max(a, b *= 10000.0);
                } else {
                    if (!dd[1].contains("%") || dd[0].contains("%")) throw new IllegalArgumentException(this.domain);
                    double a = new Double(dd[1].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    b = new Double(dd[0]);
                    v1 = Math.max(a, b *= 10000.0);
                }
            }
        }
        double v2 = area;
        if (!d[1].equalsIgnoreCase("")) {
            double a;
            String[] dd;
            if (d[1].contains("min")) {
                dd = d[1].replace("min(", "").replace(")", "").split("\\|", 2);
                if (dd[0].contains("%") && !dd[1].contains("%")) {
                    a = new Double(dd[0].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    double b = new Double(dd[1]);
                    v2 = Math.min(a, b *= 10000.0);
                } else {
                    if (!dd[1].contains("%") || dd[0].contains("%")) throw new IllegalArgumentException(this.domain);
                    a = new Double(dd[1].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    double b = new Double(dd[0]);
                    v2 = Math.min(a, b *= 10000.0);
                }
            } else if (d[1].contains("max")) {
                dd = d[1].replace("max(", "").replace(")", "").split("\\|", 2);
                if (dd[0].contains("%") && !dd[1].contains("%")) {
                    a = new Double(dd[0].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    double b = new Double(dd[1]);
                    v2 = Math.max(a, b *= 10000.0);
                } else {
                    if (!dd[1].contains("%") || dd[0].contains("%")) throw new IllegalArgumentException(this.domain);
                    a = new Double(dd[1].replace("%", ""));
                    a = new Double(a * (double)area / 100.0).intValue();
                    double b = new Double(dd[0]);
                    v2 = Math.max(a, b *= 10000.0);
                }
            }
        }
        StringBuilder domain2 = new StringBuilder();
        domain2.append(this.domain.charAt(0));
        domain2.append(v1);
        domain2.append(',');
        domain2.append(v2);
        domain2.append(this.domain.charAt(this.domain.length() - 1));
        this.domain = domain2.toString();
        return this.buildIntDomain(1.0);
    }

    private Domain<Integer, Integer> buildPercentDomain(int max) {
        String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").replace("%", "").split(",", 2);
        int area = max;
        double v1 = 0.0;
        if (!d[0].equalsIgnoreCase("")) {
            v1 = new Double(d[0]);
            v1 = new Double(v1 * (double)area / 100.0).intValue();
        }
        double v2 = area;
        if (!d[1].equalsIgnoreCase("")) {
            v2 = new Double(d[1]);
            v2 = new Double(v2 * (double)area / 100.0).intValue();
        }
        StringBuilder domain2 = new StringBuilder();
        domain2.append(this.domain.charAt(0));
        domain2.append(v1);
        domain2.append(',');
        domain2.append(v2);
        domain2.append(this.domain.charAt(this.domain.length() - 1));
        this.domain = domain2.toString();
        return this.buildIntDomain(1.0);
    }

    private Domain<Integer, Integer> buildDistanceDomain() {
        return this.buildIntDomain(1000.0);
    }

    private Domain<Integer, Integer> buildIntDomain(double coeff) {
        if (this.domain.startsWith("[")) {
            if (this.domain.endsWith("]")) {
                String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").split(",", 2);
                if (!d[0].equalsIgnoreCase("")) {
                    int d0 = new Double(Double.parseDouble(d[0]) * coeff).intValue();
                    if (!d[1].equalsIgnoreCase("")) {
                        int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                        return new AndDomain<Integer, Integer>(new NumberDomain(">=", d0), new NumberDomain("<=", d1));
                    }
                    return new NumberDomain<Integer, Integer>(">=", d0);
                }
                if (!d[1].equalsIgnoreCase("")) {
                    int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                    return new NumberDomain<Integer, Integer>("<=", d1);
                }
                return new AllDomain();
            }
            String[] d = this.domain.replace("[", "").replace(" ", "").split(",", 2);
            if (!d[0].equalsIgnoreCase("")) {
                int d0 = new Double(Double.parseDouble(d[0]) * coeff).intValue();
                if (!d[1].equalsIgnoreCase("")) {
                    int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                    return new AndDomain<Integer, Integer>(new NumberDomain(">=", d0), new NumberDomain("<", d1));
                }
                return new NumberDomain<Integer, Integer>(">=", d0);
            }
            if (!d[1].equalsIgnoreCase("")) {
                int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                return new NumberDomain<Integer, Integer>("<", d1);
            }
            return new AllDomain();
        }
        if (this.domain.endsWith("]")) {
            String[] d = this.domain.replace("]", "").replace(" ", "").split(",", 2);
            if (!d[0].equalsIgnoreCase("")) {
                int d0 = new Double(Double.parseDouble(d[0]) * coeff).intValue();
                if (!d[1].equalsIgnoreCase("")) {
                    int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                    return new AndDomain<Integer, Integer>(new NumberDomain(">", d0), new NumberDomain("<=", d1));
                }
                return new NumberDomain<Integer, Integer>(">", d0);
            }
            if (!d[1].equalsIgnoreCase("")) {
                int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                return new NumberDomain<Integer, Integer>("<=", d1);
            }
            return new AllDomain();
        }
        String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").split(",", 2);
        if (!d[0].equalsIgnoreCase("")) {
            int d0 = new Double(Double.parseDouble(d[0]) * coeff).intValue();
            if (!d[1].equalsIgnoreCase("")) {
                int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
                return new AndDomain<Integer, Integer>(new NumberDomain(">", d0), new NumberDomain("<", d1));
            }
            return new NumberDomain<Integer, Integer>(">", d0);
        }
        if (!d[1].equalsIgnoreCase("")) {
            int d1 = new Double(Double.parseDouble(d[1]) * coeff).intValue();
            return new NumberDomain<Integer, Integer>("<", d1);
        }
        return new AllDomain();
    }

    private Domain<Integer, Integer> buildBoundedDomain(double coeff, int declaredMin, int declaredMax) {
        if (this.domain.contains("[") || this.domain.contains("]")) {
            if (this.domain.startsWith("[")) {
                if (this.domain.endsWith("]")) {
                    String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").split(",", 2);
                    int d0 = !d[0].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[0]) * coeff).intValue() : declaredMin;
                    int d1 = !d[1].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[1]) * coeff).intValue() : declaredMax;
                    return new BoundedDomain<Integer, Integer>(">=", d0, "<=", d1);
                }
                String[] d = this.domain.replace("[", "").split(",", 2);
                int d0 = !d[0].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[0]) * coeff).intValue() : declaredMin;
                int d1 = !d[1].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[1]) * coeff).intValue() : declaredMax;
                return new BoundedDomain<Integer, Integer>(">=", d0, "<", d1);
            }
            if (this.domain.endsWith("]")) {
                String[] d = this.domain.replace("]", "").split(",", 2);
                int d0 = !d[0].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[0]) * coeff).intValue() : declaredMin;
                int d1 = !d[1].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[1]) * coeff).intValue() : declaredMax;
                return new BoundedDomain<Integer, Integer>(">", d0, "<=", d1);
            }
            String[] d = this.domain.replace("[", "").replace("]", "").split(",", 2);
            int d0 = !d[0].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[0]) * coeff).intValue() : declaredMin;
            int d1 = !d[1].equalsIgnoreCase("") ? new Double(Double.parseDouble(d[1]) * coeff).intValue() : declaredMax;
            return new BoundedDomain<Integer, Integer>(">", d0, "<", d1);
        }
        this.domain = "[" + this.domain + "," + this.domain + "]";
        return this.buildBoundedDomain(coeff, declaredMin, declaredMax);
    }

    private Domain<Boolean, Parcel> buildBooleanDomain() {
        if (this.domain.startsWith("[") && this.domain.endsWith("]")) {
            String[] d = this.domain.replace("[", "").replace("]", "").replace(" ", "").split("=", 2);
            boolean bool = CAPFarm.parseBoolean(d[1]);
            return new VariableBooleanDomain(d[0], bool);
        }
        return null;
    }
}

