/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.constraint;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintMode;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.ConstraintType;
import fr.inra.sad.bagap.apiland.capfarm.model.constraint.CoverAllocationConstraint;
import fr.inra.sad.bagap.apiland.capfarm.model.domain.Domain;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.composition.Attribute;
import fr.inra.sad.bagap.apiland.core.composition.TemporalValue;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.YearDelay;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.variables.IntVar;

public class DelayConstraint
extends CoverAllocationConstraint<Integer, Integer> {
    private static final long serialVersionUID = 1L;
    private Set<CoverUnit> targets;

    public DelayConstraint(String code, boolean checkOnly, ConstraintMode mode, Set<Cover> covers, Set<Parcel> parcels, Domain<Integer, Integer> domain, Set<Cover> targets) {
        super(code, checkOnly, ConstraintType.Delay, mode, covers, parcels, domain);
        this.targets = this.getCoverUnits(targets);
    }

    @Override
    public void post(CoverAllocationProblem cap) {
        for (Parcel p : this.location()) {
            int ip = cap.parcels().get(p);
            Attribute<?> attribute = p.getAttribute("cover");
            Instant last = null;
            for (Cover cover : this.covers()) {
                Instant lastc = attribute.getLastOccurence(cover);
                if (last != null && (lastc == null || !lastc.isAfter(last))) continue;
                last = lastc;
            }
            block6: for (Cover cover : this.targets) {
                int ict = cap.covers().get(cover);
                switch (this.mode()) {
                    case NEVER: {
                        for (Cover cover2 : this.covers()) {
                            if (cover2.equals(cover)) {
                                if (attribute.getLast() == null || ((Cover)((TemporalValue)attribute.getLast()).getValue()).equals(cover2) || last == null || !this.domain().accept(cap.getTime().year() - last.year() + 1)) continue;
                                cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ict, ip), (String)"=", (int)0));
                                continue;
                            }
                            if (last == null || !this.domain().accept(cap.getTime().year() - last.year() + 1)) continue;
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ict, ip), (String)"=", (int)0));
                        }
                        continue block6;
                    }
                    case ONLY: {
                        Iterator<CoverUnit> iterator = this.covers().iterator();
                        if (!iterator.hasNext()) continue block6;
                        Cover cover3 = iterator.next();
                        if (cover3.equals(cover)) {
                            if (attribute.getLast() == null || ((Cover)((TemporalValue)attribute.getLast()).getValue()).equals(cover3)) continue block6;
                            if (last != null && !this.domain().accept(cap.getTime().year() - last.year() + 1)) {
                                cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ict, ip), (String)"=", (int)0));
                            }
                            if (last == null || !this.domain().accept(cap.getTime().year() - last.year() + 1) || this.domain().accept(cap.getTime().year() - last.year() + 2)) continue block6;
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ict, ip), (String)"=", (int)1));
                            break;
                        }
                        if (last != null && !this.domain().accept(cap.getTime().year() - last.year() + 1)) {
                            cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ict, ip), (String)"=", (int)0));
                        }
                        if (last == null || !this.domain().accept(cap.getTime().year() - last.year() + 1) || this.domain().accept(cap.getTime().year() - last.year() + 2)) continue block6;
                        cap.solver().post(ICF.arithm((IntVar)cap.coversAndParcels(ict, ip), (String)"=", (int)1));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                    }
                }
            }
        }
    }

    @Override
    public boolean check(Instant start, Instant end, boolean verbose) {
        boolean ok = true;
        StringBuilder sb = new StringBuilder();
        sb.append("delay ");
        int supermin = Integer.MAX_VALUE;
        int supermax = Integer.MIN_VALUE;
        for (Parcel p : this.location()) {
            int from = -1;
            Serializable[] s = p.getAttribute("cover").split(new YearDelay(1));
            for (int i = 0; i < s.length; ++i) {
                CoverUnit cu = (CoverUnit)s[i];
                if (from != -1 && this.targets.contains(cu)) {
                    int delay = i - from;
                    if (delay > 1) {
                        switch (this.mode()) {
                            case NEVER: {
                                if (this.domain().accept(delay)) {
                                    ok = false;
                                    if (!verbose) {
                                        return ok;
                                    }
                                    sb.append("BAD : delay " + delay + "\n");
                                    return false;
                                }
                                supermin = Math.min(supermin, delay);
                                supermax = Math.max(supermax, delay);
                                break;
                            }
                            case ONLY: {
                                if (!this.domain().accept(delay)) {
                                    ok = false;
                                    if (!verbose) {
                                        return ok;
                                    }
                                    sb.append("BAD : delay " + delay + "\n");
                                    return false;
                                }
                                supermin = Math.min(supermin, delay);
                                supermax = Math.max(supermax, delay);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("mode " + (Object)((Object)this.mode()) + " is not supported for constraint type " + (Object)((Object)this.type()));
                            }
                        }
                        from = -1;
                        continue;
                    }
                    if (!this.covers().contains(cu)) continue;
                    from = i;
                    continue;
                }
                if (!this.covers().contains(cu)) continue;
                from = i;
            }
        }
        if (verbose) {
            if (supermin == supermax) {
                sb.append("GOOD : cover " + this.covers().toString() + " has delay time = " + supermin);
            } else {
                sb.append("GOOD : cover " + this.covers().toString() + " has delay time between min = " + supermin + " and max = " + supermax);
            }
            System.out.println(sb.toString());
        }
        return ok;
    }
}

