/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfilFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.MaeliaManagmentProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.ManagmentProfilFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.csp.EconomicCoverAllocationProblem;
import fr.inra.sad.bagap.apiland.core.time.Instant;

public class EconomicCoverAllocationProblemFactory
extends CoverAllocationProblemFactory {
    private String economicProfil;
    private String workProfil;
    private String distanceCoversProfil;

    public EconomicCoverAllocationProblemFactory(String economicProfil, String workProfil, String distanceCoversProfil) {
        this.economicProfil = economicProfil;
        this.workProfil = workProfil;
        this.distanceCoversProfil = distanceCoversProfil;
    }

    @Override
    public CoverAllocationProblem create(CoverAllocator coverAllocator, Instant t) {
        CoverUnit[] covers = new CoverUnit[coverAllocator.coverUnits().size()];
        int index = 0;
        for (CoverUnit cu : coverAllocator.coverUnits()) {
            covers[index++] = cu;
        }
        EconomicProfil ep = null;
        if (this.economicProfil != null) {
            ep = EconomicProfilFactory.create(covers, this.economicProfil);
        }
        MaeliaManagmentProfil mp = null;
        if (this.workProfil != null) {
            mp = this.distanceCoversProfil != null ? ManagmentProfilFactory.create(covers, this.workProfil, this.distanceCoversProfil) : ManagmentProfilFactory.create(covers, this.workProfil);
        }
        return new EconomicCoverAllocationProblem(coverAllocator, t, ep, mp);
    }
}

