/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic;

import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import java.util.Set;

public abstract class ManagmentProfil {
    private CoverUnit[] covers;
    private int[] works;

    public ManagmentProfil(CoverUnit[] covers, int[] works) {
        this.covers = covers;
        this.works = works;
    }

    public CoverUnit[] getCovers() {
        return this.covers;
    }

    public int[] getWorks() {
        return this.works;
    }

    public int work(CoverUnit cu, int area) {
        int w = this.work(this.getCoverIndex(cu));
        return w * new Double(area).intValue();
    }

    private int getCoverIndex(CoverUnit cu) {
        for (int i = 0; i < this.getCovers().length; ++i) {
            if (!this.getCovers()[i].equals(cu)) continue;
            return i;
        }
        return -1;
    }

    public int[] works() {
        int[] works = new int[this.getCovers().length];
        for (int i = 0; i < this.getCovers().length; ++i) {
            works[i] = this.work(i);
        }
        return works;
    }

    public int[] works(Set<CoverUnit> cs) {
        int[] works = new int[this.getCovers().length];
        for (int i = 0; i < this.getCovers().length; ++i) {
            works[i] = cs.contains(this.getCovers()[i]) ? this.work(i) : 0;
        }
        return works;
    }

    protected abstract int work(int var1);

    public void display(int[] areas) {
        double work_total = 0.0;
        for (int i = 0; i < this.getCovers().length; ++i) {
            work_total += (double)(areas[i] * this.work(i));
        }
        System.out.println("work total = " + work_total);
    }
}

