/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.csp;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.ManagmentProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.search.loop.monitors.SMF;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.ArrayUtils;

public class EconomicCoverAllocationProblem
extends CoverAllocationProblem {
    private IntVar[] coverAreas;
    private EconomicProfil economicProfil;
    private ManagmentProfil managmentProfil;

    public EconomicCoverAllocationProblem(CoverAllocator allocator, Instant t, EconomicProfil ep, ManagmentProfil mp) {
        super(allocator, t);
        this.economicProfil = ep;
        this.managmentProfil = mp;
    }

    public EconomicProfil getEconomicProfil() {
        return this.economicProfil;
    }

    public ManagmentProfil getManagmentProfil() {
        return this.managmentProfil;
    }

    public IntVar[] coverAreas() {
        return this.coverAreas;
    }

    @Override
    protected void buildVariables() {
        super.buildVariables();
        this.coverAreas = new IntVar[this.covers().size()];
    }

    @Override
    protected void structureInitialisation() {
        super.structureInitialisation();
        int totarea = this.allocator().totalParcelsArea();
        int[] areas = new int[this.allocator().parcels().size()];
        int[] counts = new int[this.allocator().parcels().size()];
        for (int i = 0; i < areas.length; ++i) {
            areas[i] = 0;
            counts[i] = 1;
        }
        for (Parcel p : this.parcels().keySet()) {
            areas[this.parcels().get((Object)p).intValue()] = p.getArea() / 100;
        }
        for (CoverUnit c : this.covers().keySet()) {
            int ic = this.covers().get(c);
            this.coverAreas[ic] = VF.bounded((String)("a_cvs_" + ic), (int)0, (int)totarea, (Solver)this.solver());
            this.solver().post(ICF.scalar((IntVar[])this.coversAndParcels(ic), (int[])areas, (IntVar)this.coverAreas[ic]));
        }
    }

    @Override
    protected void configureSearch() {
        long r = new Double(Math.random() * 1.0E9).longValue();
        IntStrategy as1 = ISF.random((IntVar[])((IntVar[])ArrayUtils.append((Object[][])this.coversAndParcels)), (long)r);
        IntStrategy as2 = ISF.random((IntVar[])this.parcelsImplantedCoverContinue, (long)r);
        this.solver.set(new AbstractStrategy[]{ISF.lastConflict((Solver)this.solver, (AbstractStrategy)new StrategiesSequencer(new AbstractStrategy[]{as1, as2}))});
        SMF.limitTime((Solver)this.solver, (long)100L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean solve() {
        if (this.solver.findSolution()) {
            for (Variable v : this.solver.getVars()) {
                void var5_6;
                if (v.getName().equalsIgnoreCase("profit")) {
                    this.allocator().getTerritory().getAttribute("profit").setValue(this.time(), Integer.valueOf(((IntVar)v).getValue()));
                }
                if (v.getName().equalsIgnoreCase("sum")) {
                    // empty if block
                }
                for (CoverUnit c : this.covers().keySet()) {
                    int ic = this.covers().get(c);
                    if (!v.getName().equalsIgnoreCase("a_cvs_" + ic)) continue;
                }
                if (v.getName().equalsIgnoreCase("coeffvar")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("profit")) {
                    // empty if block
                }
                boolean bl = false;
                while (var5_6 < 10) {
                    if (v.getName().equalsIgnoreCase("profit" + (int)var5_6)) {
                        // empty if block
                    }
                    if (v.getName().equalsIgnoreCase("profit" + (int)var5_6 + "div10000")) {
                        // empty if block
                    }
                    if (v.getName().equalsIgnoreCase("profit" + (int)var5_6 + "carre")) {
                        // empty if block
                    }
                    ++var5_6;
                }
                if (v.getName().equalsIgnoreCase("profitdiv1000")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("profitcarre")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("sum")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("moyenne")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("moyennecarre")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("sumprofitcarres")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("sumprofitcarressurtaille")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("variance")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("racinevariance")) {
                    // empty if block
                }
                if (v.getName().equalsIgnoreCase("ecarttype")) {
                    // empty if block
                }
                if (!v.getName().equalsIgnoreCase("ecarttype10000")) continue;
            }
            block3: for (Parcel p : this.parcels().keySet()) {
                int ip = this.parcels().get(p);
                if (this.parcelsImplantedCoverContinue[ip].getValue() != 0) continue;
                for (Cover cover : this.covers().keySet()) {
                    int ic = this.covers().get(cover);
                    if (this.coversAndParcels[ic][ip].getValue() != 1) continue;
                    p.getAttribute("cover").setValue(this.time(), cover);
                    continue block3;
                }
            }
            return true;
        }
        return false;
    }
}

