/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.model.economic.csp;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.MaeliaManagmentProfil;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import java.util.Set;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ICF;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.SMF;
import org.chocosolver.solver.search.strategy.ISF;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.search.strategy.strategy.IntStrategy;
import org.chocosolver.solver.search.strategy.strategy.StrategiesSequencer;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.VF;
import org.chocosolver.util.tools.ArrayUtils;

public class OptimizeEconomicCoverAllocationProblem
extends CoverAllocationProblem {
    private EconomicProfil ep;
    private MaeliaManagmentProfil mp;
    private IntVar profit;
    private IntVar unprofit;
    private IntVar work;
    private IntVar sumDiffProfitsDiv1000AuCarre;
    private IntVar nbcombinations;
    private IntVar variance;
    private IntVar distance;
    private IntVar[] coverAreas;
    private IntVar[] profits;
    private IntVar[] diffProfitsDiv1000AuCarre;
    private BoolVar[] allocatedCovers;

    public OptimizeEconomicCoverAllocationProblem(CoverAllocator allocator, Instant t, EconomicProfil ep, MaeliaManagmentProfil mp) {
        super(allocator, t);
        this.ep = ep;
        this.mp = mp;
    }

    public EconomicProfil getEconomicProfil() {
        return this.ep;
    }

    public IntVar[] coverAreas() {
        return this.coverAreas;
    }

    @Override
    protected void buildVariables() {
        super.buildVariables();
        this.profit = VF.bounded((String)"profit", (int)0, (int)2000000000, (Solver)this.solver);
        this.unprofit = VF.bounded((String)"unprofit", (int)-2000000000, (int)0, (Solver)this.solver);
        this.work = VF.bounded((String)"work", (int)0, (int)21474836, (Solver)this.solver);
        this.coverAreas = new IntVar[this.covers().size()];
    }

    @Override
    protected void structureInitialisation() {
        super.structureInitialisation();
        int totarea = this.allocator().totalParcelsArea();
        System.out.println("total area " + totarea);
        int[] areas = new int[this.allocator().parcels().size()];
        for (int i = 0; i < areas.length; ++i) {
            areas[i] = 0;
        }
        for (Parcel p : this.parcels().keySet()) {
            areas[this.parcels().get((Object)p).intValue()] = p.getArea() / 100;
        }
        for (CoverUnit c : this.covers().keySet()) {
            int ic = this.covers().get(c);
            this.coverAreas[ic] = VF.bounded((String)("a_cvs_" + ic), (int)0, (int)totarea, (Solver)this.solver());
            this.solver().post(ICF.scalar((IntVar[])this.coversAndParcels(ic), (int[])areas, (IntVar)this.coverAreas[ic]));
        }
        this.solver().post(ICF.arithm((IntVar)this.profit, (String)"+", (IntVar)this.unprofit, (String)"=", (int)0));
        this.solver().post(ICF.scalar((IntVar[])this.coverAreas, (int[])this.ep.profits(), (IntVar)this.profit));
        this.solver().post(ICF.scalar((IntVar[])this.coverAreas, (int[])this.mp.works(), (IntVar)this.work));
        int[][] historicalProfits = this.ep.getHistoricalProfits();
        int nbCombinations = historicalProfits[0].length;
        int nbCovers = this.coverAreas().length;
        this.profits = new IntVar[nbCombinations];
        this.diffProfitsDiv1000AuCarre = new IntVar[nbCombinations];
        IntVar divisor = VF.fixed((int)1000, (Solver)this.solver());
        for (int h = 0; h < nbCombinations; ++h) {
            IntVar profith = VF.bounded((String)("profit" + h), (int)0, (int)21474836, (Solver)this.solver());
            int[] hp = new int[nbCovers];
            for (int s = 0; s < nbCovers; ++s) {
                hp[s] = historicalProfits[s][h];
            }
            this.solver().post(ICF.scalar((IntVar[])this.coverAreas(), (int[])hp, (IntVar)profith));
            this.profits[h] = profith;
            IntVar diffProfith = VF.bounded((String)("diffprofit" + h), (int)0, (int)100000000, (Solver)this.solver());
            this.solver().post(ICF.distance((IntVar)this.profit, (IntVar)profith, (String)"=", (IntVar)diffProfith));
            IntVar diffProfithDiv1000 = VF.bounded((String)("diffprofit" + h + "div1000"), (int)0, (int)100000000, (Solver)this.solver());
            this.solver().post(ICF.eucl_div((IntVar)diffProfith, (IntVar)divisor, (IntVar)diffProfithDiv1000));
            IntVar diffProfithDiv1000AuCarre = VF.bounded((String)("diffprofit" + h + "div1000aucarre"), (int)0, (int)21474836, (Solver)this.solver());
            this.solver().post(ICF.square((IntVar)diffProfithDiv1000AuCarre, (IntVar)diffProfithDiv1000));
            this.diffProfitsDiv1000AuCarre[h] = diffProfithDiv1000AuCarre;
        }
        this.sumDiffProfitsDiv1000AuCarre = VF.bounded((String)"sumdiffprofitdiv1000aucarre", (int)0, (int)21474836, (Solver)this.solver());
        this.solver().post(ICF.sum((IntVar[])this.diffProfitsDiv1000AuCarre, (IntVar)this.sumDiffProfitsDiv1000AuCarre));
        this.nbcombinations = VF.bounded((String)"nbcombinations", (int)nbCombinations, (int)nbCombinations, (Solver)this.solver());
        this.variance = VF.bounded((String)"variance", (int)0, (int)10000000, (Solver)this.solver());
        this.solver().post(ICF.eucl_div((IntVar)this.sumDiffProfitsDiv1000AuCarre, (IntVar)this.nbcombinations, (IntVar)this.variance));
        Set<CoverUnit> historicalCovers = this.historicalCovers();
        int[][] distanceCovers = this.mp.getDistanceCovers();
        if (distanceCovers != null) {
            int[] expCovers = new int[this.covers().size()];
            for (CoverUnit cu1 : this.covers().keySet()) {
                int min = 10;
                for (CoverUnit cu2 : this.covers().keySet()) {
                    if (!historicalCovers.contains(cu2)) continue;
                    min = Math.min(min, distanceCovers[this.covers().get(cu2)][this.covers().get(cu1)]);
                }
                expCovers[this.covers().get((Object)cu1).intValue()] = min;
            }
            this.allocatedCovers = new BoolVar[this.covers().size()];
            for (int ic = 0; ic < this.covers().size(); ++ic) {
                BoolVar ac = VF.bool((String)("alloc" + ic), (Solver)this.solver());
                Constraint ct = ICF.arithm((IntVar)this.coverAreas[ic], (String)">", (int)0);
                this.solver().post(ICF.arithm((IntVar)ac, (String)"=", (IntVar)ct.reif()));
                this.allocatedCovers[ic] = ac;
            }
            this.distance = VF.bounded((String)"distancecovers", (int)0, (int)(this.covers().size() * 10), (Solver)this.solver());
            this.solver().post(ICF.scalar((IntVar[])this.allocatedCovers, (int[])expCovers, (IntVar)this.distance));
        }
    }

    @Override
    protected void configureSearch() {
        long r = new Double(Math.random() * 1.0E9).longValue();
        IntStrategy as1 = ISF.random((IntVar[])((IntVar[])ArrayUtils.append((Object[][])this.coversAndParcels)), (long)r);
        IntStrategy as2 = ISF.random((IntVar[])this.parcelsImplantedCoverContinue, (long)r);
        this.solver.set(new AbstractStrategy[]{ISF.lastConflict((Solver)this.solver, (AbstractStrategy)new StrategiesSequencer(new AbstractStrategy[]{as1, as2}))});
        SMF.limitTime((Solver)this.solver, (long)1000L);
    }

    @Override
    protected boolean solve() {
        this.solver.findParetoFront(ResolutionPolicy.MINIMIZE, new IntVar[]{this.unprofit, this.work, this.variance});
        if (this.solver.findSolution()) {
            try {
                this.solver.restoreLastSolution();
                System.out.println("profit = " + this.profit.getValue() / 100 + " euros");
                System.out.println("coeff var profit = " + 1000.0 * Math.sqrt(this.variance.getValue()) / ((double)this.profit.getValue() / 100.0));
                block2: for (Parcel p : this.parcels().keySet()) {
                    int ip = this.parcels().get(p);
                    if (this.parcelsImplantedCoverContinue[ip].getValue() != 0) continue;
                    for (Cover cover : this.covers().keySet()) {
                        int ic = this.covers().get(cover);
                        if (this.coversAndParcels(ic, ip).getValue() != 1) continue;
                        p.getAttribute("cover").setValue(this.time(), cover);
                        continue block2;
                    }
                }
                return true;
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

