/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.capfarm.csp.ProbaTimeManager;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmFactory;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmManager;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class CfmSimulator
extends Simulator {
    private static final long serialVersionUID = 1L;

    public CfmSimulator(CfmManager manager) {
        super(manager, new CfmFactory());
    }

    @Override
    public CfmManager manager() {
        return (CfmManager)super.manager();
    }

    public boolean allRun() {
        boolean simulationOk = true;
        this.init(1);
        simulationOk = this.run();
        this.close();
        return simulationOk;
    }

    @Override
    protected void initModel() {
        this.initProbaTimes();
        this.initTerritory();
        this.initFarms();
        this.initOutput();
    }

    private List<InputStream> readJar(String filename, String folder) {
        File file = new File(filename);
        if (!filename.endsWith(".jar") || !file.exists()) {
            System.out.println("Fichier jar introuvable: " + filename);
            return null;
        }
        try {
            ArrayList<InputStream> files = new ArrayList<InputStream>();
            JarFile jarfile = new JarFile(filename);
            Enumeration<JarEntry> elem = jarfile.entries();
            while (elem.hasMoreElements()) {
                ZipEntry ze = elem.nextElement();
                if (!ze.getName().contains(folder) || ze.getName().length() <= folder.length()) continue;
                files.add(jarfile.getInputStream(ze));
            }
            return files;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    private void initProbaTimes() {
        try {
            String probaTimeFolder = this.manager().probaTimeFolder();
            ProbaTimeManager.initProbaTimes();
            if (probaTimeFolder.startsWith("jar:")) {
                String[] s = probaTimeFolder.split("!");
                String jar = s[0].replace("file:/", "").replace("jar:", "");
                String ptf = s[1].replaceFirst("/", "");
                JarFile jarfile = new JarFile(jar);
                Enumeration<JarEntry> elem = jarfile.entries();
                while (elem.hasMoreElements()) {
                    ZipEntry ze = elem.nextElement();
                    if (!ze.getName().contains(ptf) || ze.getName().length() <= ptf.length()) continue;
                    InputStream in = jarfile.getInputStream(ze);
                    BufferedReader buf = new BufferedReader(new InputStreamReader(in));
                    String name = new File(ze.getName()).getName().replace(".txt", "");
                    ProbaTimeManager.addProbaType(name);
                    CsvReader cr = new CsvReader((Reader)buf);
                    cr.setDelimiter(';');
                    cr.readHeaders();
                    while (cr.readRecord()) {
                        int time = Integer.parseInt(cr.get("time"));
                        ProbaTimeManager.addProbaTime(name, time);
                        String[] probas = cr.get("probas").split("\\|");
                        ProbaTimeManager.addProbaTimes(name, time, probas);
                    }
                    buf.close();
                    cr.close();
                    in.close();
                }
                jarfile.close();
            } else {
                File folder = new File(this.manager().probaTimeFolder().replace("file:/", ""));
                for (File duration : folder.listFiles()) {
                    String name = duration.getName().replace(".txt", "");
                    ProbaTimeManager.addProbaType(name);
                    CsvReader cr = new CsvReader(duration.toString());
                    cr.setDelimiter(';');
                    cr.readHeaders();
                    while (cr.readRecord()) {
                        int time = Integer.parseInt(cr.get("time"));
                        ProbaTimeManager.addProbaTime(name, time);
                        String[] probas = cr.get("probas").split("\\|");
                        ProbaTimeManager.addProbaTimes(name, time, probas);
                    }
                    cr.close();
                }
            }
        }
        catch (CsvReader.CatastrophicException | CsvReader.FinalizedException | IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract void initFarms();

    private void initTerritory() {
        this.map().put("territory", this.manager().territory());
    }

    private void initOutput() {
        for (OutputAnalysis oa : this.manager().outputs()) {
            this.addOutput(oa);
        }
    }
}

