/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.landscape;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.Farm;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.EconomicCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.economic.OptimizeEconomicCoverAllocationProblemFactory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.AgriculturalArea;
import fr.inra.sad.bagap.apiland.capfarm.simul.CSPCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmProcessMode;
import fr.inra.sad.bagap.apiland.capfarm.simul.CfmSimulator;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.MemoryCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.landscape.CfmLandscapeManager;
import fr.inra.sad.bagap.apiland.capfarm.simul.landscape.GlobalConstraintsCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.simul.Simulator;

public class CfmLandscapeSimulator
extends CfmSimulator {
    private static final long serialVersionUID = 1L;

    public CfmLandscapeSimulator(CfmLandscapeManager manager) {
        super(manager);
    }

    @Override
    public CfmLandscapeManager manager() {
        return (CfmLandscapeManager)super.manager();
    }

    @Override
    protected void initFarms() {
        if (this.manager().processMode().equals((Object)CfmProcessMode.LANDSCAPE)) {
            GlobalConstraintsCoverLocationModel agriculture = new GlobalConstraintsCoverLocationModel("agriculture", (Simulator)this, this.manager().getCoverAllocator());
            agriculture.setTerritory((AgriculturalArea)((DynamicLayer)this.map().get("territory")).get("AA"));
            for (Farm f : this.manager().farms()) {
                f.setMemory(true);
                agriculture.add(new MemoryCoverLocationModel(this, f, true));
            }
            this.model().add(agriculture);
        } else {
            GlobalCoverLocationModel agriculture = new GlobalCoverLocationModel("agriculture", this);
            agriculture.setTerritory((AgriculturalArea)((DynamicLayer)this.map().get("territory")).get("AA"));
            block10: for (Farm f : this.manager().farms()) {
                switch (this.manager().processMode()) {
                    case ACTIVATE: {
                        CoverAllocationProblemFactory factory = null;
                        switch (this.manager().mode()) {
                            case IDLE: {
                                factory = new CoverAllocationProblemFactory();
                                break;
                            }
                            case ECONOMIC: {
                                factory = new EconomicCoverAllocationProblemFactory(this.manager().economicProfil(), this.manager().workProfil(), null);
                                break;
                            }
                            case OPTIMIZE: {
                                factory = new OptimizeEconomicCoverAllocationProblemFactory(this.manager().economicProfil(), null, null);
                            }
                        }
                        agriculture.add(new CSPCoverLocationModel(this, f, factory));
                        continue block10;
                    }
                    case MEMORY: {
                        f.setMemory(true);
                        agriculture.add(new MemoryCoverLocationModel((CfmSimulator)this, f));
                        continue block10;
                    }
                }
                throw new IllegalArgumentException((Object)((Object)this.manager().processMode()) + " not implemented yet");
            }
            this.model().add(agriculture);
        }
    }
}

