/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.landscape;

import fr.inra.sad.bagap.apiland.capfarm.csp.CoverAllocator;
import fr.inra.sad.bagap.apiland.capfarm.csp.FixedCoverAllocationProblem;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.FarmTerritory;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.MemoryCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import java.util.HashMap;

public class GlobalConstraintsCoverLocationModel
extends GlobalCoverLocationModel {
    private static final long serialVersionUID = 1L;
    private CoverAllocator coverAllocator;

    public GlobalConstraintsCoverLocationModel(String name, Simulator simulator, CoverAllocator coverAllocator) {
        super(name, simulator);
        this.coverAllocator = coverAllocator;
    }

    public CoverAllocator getCoverAllocator() {
        return this.coverAllocator;
    }

    @Override
    public boolean run(Instant t) {
        HashMap<Parcel, CoverUnit> fixed = new HashMap<Parcel, CoverUnit>();
        for (CoverLocationModel model : this) {
            for (Parcel p : ((FarmTerritory)model.getElement()).parcels()) {
                fixed.put(p, ((MemoryCoverLocationModel)model).getCover(p.getId(), t));
            }
        }
        if (new FixedCoverAllocationProblem(this.coverAllocator, t, fixed).execute()) {
            for (CoverLocationModel model : this) {
                model.run(t);
            }
            return true;
        }
        return false;
    }
}

