/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.capfarm.simul.output;

import fr.inra.sad.bagap.apiland.capfarm.model.Cover;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverManager;
import fr.inra.sad.bagap.apiland.capfarm.model.CoverUnit;
import fr.inra.sad.bagap.apiland.capfarm.model.territory.Parcel;
import fr.inra.sad.bagap.apiland.capfarm.simul.CoverLocationModel;
import fr.inra.sad.bagap.apiland.capfarm.simul.GlobalCoverLocationModel;
import fr.inra.sad.bagap.apiland.core.composition.StaticAttribute;
import fr.inra.sad.bagap.apiland.core.element.manager.DynamicLayerFactory;
import fr.inra.sad.bagap.apiland.core.element.type.DynamicElementTypeFactory;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.OutputAnalysis;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.Simulation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GlobalShapefileByCoverOutput
extends OutputAnalysis {
    private Map<Parcel, Map<CoverUnit, Integer>> count = new HashMap<Parcel, Map<CoverUnit, Integer>>();

    @Override
    public void init(Scenario scenario) {
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            for (Parcel p : model.getCoverAllocator().parcels()) {
                this.count.put(p, new HashMap());
                for (CoverUnit c : CoverManager.coverUnits()) {
                    if (!p.getType().hasAttributeType("nb_" + c.getCode())) {
                        p.getType().addAttributeType(DynamicElementTypeFactory.createAttributeType("nb_" + c.getCode(), null, Integer.class));
                    }
                    p.getComposition().addAttribute(new StaticAttribute(DynamicElementTypeFactory.createAttributeType("nb_" + c.getCode(), null, Integer.class)));
                    this.count.get(p).put(c, 0);
                }
            }
        }
    }

    @Override
    public void close(Simulation simulation) {
        if (!simulation.isCancelled()) {
            for (CoverLocationModel model : (GlobalCoverLocationModel)simulation.model().get("agriculture")) {
                System.out.println(model);
                for (Parcel p : model.getCoverAllocator().parcels()) {
                    System.out.println("parcel : " + p);
                    Instant t = simulation.manager().start();
                    while (t.isBefore(simulation.manager().end()) || t.equals(simulation.manager().end())) {
                        CoverUnit cu = (CoverUnit)p.getAttribute("cover").getValue(t);
                        this.count.get(p).put(cu, this.count.get(p).get(cu) + 1);
                        System.out.println(t + " " + cu + " " + this.count.get(p).get(cu));
                        t = simulation.manager().delay().next(t);
                    }
                    for (CoverUnit c : CoverManager.coverUnits()) {
                        p.getAttribute("nb_" + c.getCode()).setValue(simulation.manager().start(), this.count.get(p).get(c));
                    }
                }
            }
        }
    }

    @Override
    public void close(Scenario scenario) {
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            DynamicLayerFactory.exportShape(model.getCoverAllocator().getTerritory(), scenario.manager().start(), scenario.folder() + "coverByScenario");
        }
        for (CoverLocationModel model : (GlobalCoverLocationModel)scenario.model().get("agriculture")) {
            Iterator<Parcel> iterator = model.getCoverAllocator().parcels().iterator();
            if (!iterator.hasNext()) continue;
            Parcel p = iterator.next();
            for (Cover cover : CoverManager.coverUnits()) {
                model.getCoverAllocator().getTerritory().getType().removeAttributeType("nb_" + cover.getCode());
            }
        }
    }
}

