/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.composition;

import fr.inra.sad.bagap.apiland.core.composition.AttributeType;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Interval;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import java.util.HashMap;
import java.util.Map;

public class DiscreteAttributeType
extends AttributeType {
    private static final long serialVersionUID = 1L;
    private Interval time;
    private Delay d;
    private int internalSize;
    private Map<Instant, Integer> index;

    public DiscreteAttributeType(String name, Class<?> binding, Interval time, Delay d) {
        super(name, binding);
        this.time = time;
        this.d = d;
        this.init();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("discrete attribute type : ");
        sb.append(this.name);
        sb.append(" (");
        sb.append(" object type : ");
        sb.append(this.binding.getName());
        sb.append(")\n");
        return sb.toString();
    }

    public Interval getTime() {
        return this.time;
    }

    public Delay delay() {
        return this.d;
    }

    private void init() {
        int i = 0;
        this.index = new HashMap<Instant, Integer>();
        Instant tt = this.time.start();
        Instant end = this.time.end();
        while (tt.isBefore(end) || tt.equals(end)) {
            this.index.put(tt, i);
            tt = this.d.next(tt);
            ++i;
        }
        this.internalSize = i;
    }

    public int getInternalSize() {
        return this.internalSize;
    }

    public int getIndex(Instant t) {
        try {
            return this.index.get(t);
        }
        catch (NullPointerException ex) {
            if (t.equals(this.time.end()) || t.isAfter(this.time.end())) {
                return this.getIndex(this.d.previous(this.time.end()));
            }
            Instant tt = this.time.start();
            int i = 0;
            while (tt.isBefore(t)) {
                tt = this.d.next(tt);
                ++i;
            }
            this.index.put(t, i);
            return i;
        }
    }
}

