/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.element.neighbourhood;

import fr.inra.sad.bagap.apiland.core.element.DefaultDynamicFeature;
import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.neighbourhood.NeighbourElement;
import fr.inra.sad.bagap.apiland.core.element.neighbourhood.NeighbourhoodType;
import fr.inra.sad.bagap.apiland.core.time.Instant;

public class Neighbourhood
extends DefaultDynamicFeature {
    private static final long serialVersionUID = 1L;
    private DynamicElement e1;
    private DynamicElement e2;

    public Neighbourhood(NeighbourhoodType type, NeighbourElement e1, NeighbourElement e2) {
        super(type);
        e1.addNeighbourhood(this);
        e2.addNeighbourhood(this);
    }

    @Override
    public Neighbourhood clone() {
        Neighbourhood clone = (Neighbourhood)super.clone();
        clone.e1 = this.e1;
        clone.e2 = this.e2;
        return clone;
    }

    public double length(Instant t) {
        return this.getDefaultRepresentation().getLength(t);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Neighbourhood) {
            Neighbourhood v = (Neighbourhood)other;
            if (this.e1.equals(v.e1) && this.e2.equals(v.e2) || this.e2.equals(v.e1) && this.e1.equals(v.e2)) {
                return true;
            }
        }
        return false;
    }

    public void display(Instant t) {
        System.out.println(this.e1 + " - " + this.e2 + " : " + this.length(t));
    }

    public DynamicElement getNeighbour(DynamicElement e) {
        if (this.e1.equals(e)) {
            return this.e2;
        }
        if (this.e2.equals(e)) {
            return this.e1;
        }
        throw new IllegalArgumentException();
    }

    public DynamicElement getNeighbour1() {
        return this.e1;
    }

    public DynamicElement getNeighbour2() {
        return this.e2;
    }

    public void setNeighbour(DynamicElement n) {
        if (this.e1 == null) {
            this.e1 = n;
        } else if (this.e2 == null) {
            this.e2 = n;
        } else {
            throw new IllegalArgumentException();
        }
    }
}

