/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl;

import fr.inra.sad.bagap.apiland.core.space.impl.Vectorial;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterNull;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;

public class Vector2Raster {
    private static double cell;

    public static Raster convert(Vectorial v, double cellsize) {
        if (v != null) {
            cell = cellsize;
            if (v.getJTS() instanceof Point) {
                return Vector2Raster.convertJTSPoint((Point)v.getJTS());
            }
            if (v.getJTS() instanceof LineString) {
                return Vector2Raster.convertJTSLineString((LineString)v.getJTS());
            }
            if (v.getJTS() instanceof Polygon) {
                return Vector2Raster.convertJTSPolygon((Polygon)v.getJTS());
            }
            throw new IllegalArgumentException("JTS geometry type " + v.getJTS().getGeometryType() + " is not managed yet !!!");
        }
        return null;
    }

    private static Raster convertJTSPoint(Point g) {
        return Vector2Raster.getPixel(g.getCoordinate());
    }

    private static Raster convertJTSLineString(LineString g) {
        Coordinate[] coord = g.getCoordinates();
        Coordinate c1 = coord[0];
        HashSet<Pixel> pixels = new HashSet<Pixel>();
        for (int i = 1; i < coord.length; ++i) {
            Coordinate c2 = coord[i];
            LineSegment ls = new LineSegment(c1, c2);
            Set<Coordinate> coord2 = Vector2Raster.getEnvelope(c1, c2);
            for (Coordinate c : coord2) {
                if (!(ls.distance(c) < cell * Math.sqrt(2.0) / 2.0)) continue;
                pixels.add(Vector2Raster.getPixel(c));
            }
            c1 = c2;
        }
        if (pixels.size() == 0) {
            return new RasterNull();
        }
        if (pixels.size() == 1) {
            return (Raster)pixels.iterator().next();
        }
        return new PixelComposite(pixels);
    }

    private static Raster convertJTSPolygon(Polygon g) {
        Set<Coordinate> env = Vector2Raster.getEnvelope(g.getEnvelope().getCoordinates());
        PreparedPolygon pp = new PreparedPolygon((Polygonal)g);
        HashSet<Pixel> pixels = new HashSet<Pixel>();
        for (Coordinate c : env) {
            Point p = g.getFactory().createPoint(c);
            if (!pp.intersects((Geometry)p)) continue;
            pixels.add(Vector2Raster.getPixel(p.getCoordinate()));
        }
        if (pixels.size() == 0) {
            return new RasterNull();
        }
        if (pixels.size() == 1) {
            return (Raster)pixels.iterator().next();
        }
        return new PixelComposite(pixels);
    }

    private static Set<Coordinate> getEnvelope(Coordinate[] coord) {
        HashSet<Coordinate> l = new HashSet<Coordinate>();
        boolean init = true;
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        for (Coordinate c : coord) {
            Pixel p = Vector2Raster.getPixel(c);
            if (init) {
                minX = p.x();
                maxX = p.x();
                minY = p.y();
                maxY = p.y();
                init = false;
                continue;
            }
            minX = Math.min(minX, p.x());
            maxX = Math.max(maxX, p.x());
            minY = Math.min(minY, p.y());
            maxY = Math.max(maxY, p.y());
        }
        for (int j = minY; j < maxY; ++j) {
            for (int i = minX; i < maxX; ++i) {
                l.add(PixelManager.get(i, j).getCentroid());
            }
        }
        return l;
    }

    private static Pixel getPixel(Coordinate c) {
        return PixelManager.get(new Double(Math.floor(new Double(c.x / cell))).intValue(), new Double(Math.floor(new Double(c.y / cell))).intValue());
    }

    private static Set<Coordinate> getEnvelope(Coordinate c1, Coordinate c2) {
        Pixel p1 = Vector2Raster.getPixel(c1);
        Pixel p2 = Vector2Raster.getPixel(c2);
        HashSet<Coordinate> l = new HashSet<Coordinate>();
        if (p1.x() < p2.x()) {
            if (p1.y() < p2.y()) {
                for (int j = p1.y(); j <= p2.y(); ++j) {
                    for (int i = p1.x(); i <= p2.x(); ++i) {
                        l.add(PixelManager.get(i, j).getCentroid());
                    }
                }
            } else if (p1.y() > p2.y()) {
                for (int j = p2.y(); j <= p1.y(); ++j) {
                    for (int i = p1.x(); i <= p2.x(); ++i) {
                        l.add(PixelManager.get(i, j).getCentroid());
                    }
                }
            } else {
                for (int i = p1.x(); i <= p2.x(); ++i) {
                    l.add(PixelManager.get(i, p1.y()).getCentroid());
                }
            }
        } else if (p1.x() > p2.x()) {
            if (p1.y() < p2.y()) {
                for (int j = p1.y(); j <= p2.y(); ++j) {
                    for (int i = p2.x(); i <= p1.x(); ++i) {
                        l.add(PixelManager.get(i, j).getCentroid());
                    }
                }
            } else if (p1.y() > p2.y()) {
                for (int j = p2.y(); j <= p1.y(); ++j) {
                    for (int i = p2.x(); i <= p1.x(); ++i) {
                        l.add(PixelManager.get(i, j).getCentroid());
                    }
                }
            } else {
                for (int i = p2.x(); i <= p1.x(); ++i) {
                    l.add(PixelManager.get(i, p1.y()).getCentroid());
                }
            }
        } else if (p1.y() < p2.y()) {
            for (int j = p1.y(); j <= p2.y(); ++j) {
                l.add(PixelManager.get(p1.x(), j).getCentroid());
            }
        } else if (p1.y() > p2.y()) {
            for (int j = p2.y(); j <= p1.y(); ++j) {
                l.add(PixelManager.get(p1.x(), j).getCentroid());
            }
        } else {
            l.add(p1.getCentroid());
        }
        System.out.println("liste de centroids " + l);
        return l;
    }
}

