/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster;

import fr.inra.sad.bagap.apiland.core.space.Geometry;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImpl;
import fr.inra.sad.bagap.apiland.core.space.impl.GeometryImplType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.PixelComposite;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterComposite;
import java.util.Iterator;
import java.util.Set;

public abstract class Raster
implements GeometryImpl,
Iterable<Pixel> {
    private static final long serialVersionUID = 1L;
    protected static double size = 1.0;
    private static int noDataValue = -1;
    private double userData;
    private GeometryImplType type = GeometryImplType.RASTER;
    protected boolean smooth = false;

    public Raster() {
        this.userData = noDataValue;
    }

    public double getUserData() {
        return this.userData;
    }

    public void setUserData(double userData) {
        this.userData = userData;
    }

    @Override
    public GeometryImplType getType() {
        return this.type;
    }

    public static void setCellSize(double s) {
        size = s;
    }

    public static double getCellSize() {
        return size;
    }

    public static void setNoDataValue(int ndtv) {
        noDataValue = ndtv;
    }

    public static int getNoDataValue() {
        return noDataValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Raster)) {
            return false;
        }
        for (Pixel p : this) {
            if (((Raster)o).containsPixel(p)) continue;
            return false;
        }
        for (Pixel p : (Raster)o) {
            if (this.containsPixel(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract int count();

    public abstract int size();

    @Override
    public void display() {
        System.out.println(this);
    }

    @Override
    public void init(Geometry g) {
    }

    @Override
    public Raster clone() {
        Raster clone = null;
        try {
            clone = (Raster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    @Override
    public abstract Raster smooth();

    protected void setSmooth(boolean smooth) {
        this.smooth = smooth;
    }

    @Override
    public org.locationtech.jts.geom.Geometry getJTS() {
        throw new UnsupportedOperationException();
    }

    public abstract Iterator<Pixel> getBoundaries();

    public abstract Pixel getOne();

    public abstract Iterator<Pixel> getMargins();

    protected abstract boolean equalsPixel(Pixel var1);

    protected abstract boolean equalsPixelComposite(PixelComposite var1);

    protected abstract boolean equalsRasterComposite(RasterComposite var1);

    protected abstract boolean containsPixel(Pixel var1);

    protected abstract boolean containsPixelComposite(PixelComposite var1);

    protected abstract boolean containsRasterComposite(RasterComposite var1);

    protected abstract boolean touchesPixel(Pixel var1);

    protected abstract boolean touchesPixelWithoutContainsTest(Pixel var1);

    protected abstract boolean touchesPixelComposite(PixelComposite var1);

    protected abstract boolean touchesRasterComposite(RasterComposite var1);

    protected abstract boolean withinPixel(Pixel var1);

    protected abstract boolean withinPixelComposite(PixelComposite var1);

    protected abstract boolean withinRasterComposite(RasterComposite var1);

    protected abstract boolean crossesPixel(Pixel var1);

    protected abstract boolean crossesPixelComposite(PixelComposite var1);

    protected abstract boolean crossesRasterComposite(RasterComposite var1);

    protected abstract boolean intersectsPixel(Pixel var1);

    protected abstract boolean intersectsPixelComposite(PixelComposite var1);

    protected abstract boolean intersectsRasterComposite(RasterComposite var1);

    protected abstract boolean disjointPixel(Pixel var1);

    protected abstract boolean disjointPixelComposite(PixelComposite var1);

    protected abstract boolean disjointRasterComposite(RasterComposite var1);

    protected abstract boolean overlapsPixel(Pixel var1);

    protected abstract boolean overlapsPixelComposite(PixelComposite var1);

    protected abstract boolean overlapsRasterComposite(RasterComposite var1);

    @Override
    public abstract Raster addGeometryImpl(GeometryImpl var1);

    protected abstract Raster addPixel(Pixel var1);

    protected abstract Raster addPixelComposite(PixelComposite var1);

    protected abstract Raster addRasterComposite(RasterComposite var1);

    public static double distance(PixelComposite pc1, PixelComposite pc2) {
        double min = Double.MAX_VALUE;
        for (Pixel p1 : pc1) {
            for (Pixel p2 : pc2) {
                min = Math.min(min, Math.sqrt(Math.pow(p2.x() - p1.x(), 2.0) + Math.pow(p2.y() - p1.y(), 2.0)));
            }
            if (min != 0.0) continue;
            break;
        }
        if (min == Double.MAX_VALUE) {
            min = Raster.getNoDataValue();
        }
        return min;
    }

    public static double distance(Set<Pixel> set1, Set<Pixel> set2) {
        double min = Double.MAX_VALUE;
        for (Pixel p1 : set1) {
            for (Pixel p2 : set2) {
                min = Math.min(min, Math.sqrt(Math.pow(p2.x() - p1.x(), 2.0) + Math.pow(p2.y() - p1.y(), 2.0)));
            }
            if (min != 0.0) continue;
            break;
        }
        if (min == Double.MAX_VALUE) {
            min = Raster.getNoDataValue();
        }
        return min;
    }
}

