/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixType;
import java.util.Iterator;
import java.util.Set;

public class ConwayMatrix
implements Matrix,
Iterable<Pixel> {
    private static final long serialVersionUID = 1L;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double cellsize;
    private int width;
    private int height;
    private Double[][] values;
    private String file;

    public ConwayMatrix(double cellsize, double minx, double maxx, double miny, double maxy, int width, int height, Double[][] values) {
        this.minX = minx;
        this.maxX = maxx;
        this.minY = miny;
        this.maxY = maxy;
        this.width = width;
        this.height = height;
        this.cellsize = cellsize;
        Raster.setCellSize(this.cellsize);
        this.values = values;
    }

    @Override
    public double get(int x, int y) {
        int ix = 0;
        for (int i = 0; i < this.values[y].length; i += 2) {
            if (x > (ix += this.values[y][i].intValue())) continue;
            return this.values[y][i + 1];
        }
        return Raster.getNoDataValue();
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public int size() {
        return this.width * this.height;
    }

    @Override
    public double minX() {
        return this.minX;
    }

    @Override
    public double maxX() {
        return this.maxX;
    }

    @Override
    public double minY() {
        return this.minY;
    }

    @Override
    public double maxY() {
        return this.maxY;
    }

    @Override
    public double cellsize() {
        return this.cellsize;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public Iterator<Pixel> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double get(Pixel p) {
        return this.get(p.x(), p.y());
    }

    @Override
    public void put(int x, int y, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(Pixel p, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(Raster r, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(double v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int tileWidth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int tileHeight() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numXTiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int numYTiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double minV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maxV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int noDataValue() {
        return Raster.getNoDataValue();
    }

    @Override
    public void display() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Integer> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getCouples(Matrix horizontals, Matrix verticals) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visualize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MatrixType getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getActiveArea() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Pixel p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetValues() {
    }
}

