/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.ConwayMatrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.media.jai.PlanarImage;

public class ConwayMatrixFactory
extends MatrixFactory {
    private static double minx;
    private static double maxx;
    private static double miny;
    private static double maxy;
    private static double cellsize;
    private static int width;
    private static int height;
    private static int noDataValue;
    private static ConwayMatrixFactory factory;

    private ConwayMatrixFactory() {
    }

    public static ConwayMatrixFactory get() {
        return factory;
    }

    public Matrix createWithAsciiGrid(String ascii) {
        Matrix m = this.initWithEntete(ascii);
        m.setFile(ascii);
        return m;
    }

    private Matrix initWithEntete(String ascii) throws NumberFormatException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(ascii));
            String line = br.readLine();
            String sep = String.valueOf(line.charAt(5));
            String[] s = line.split(sep);
            width = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            height = Integer.parseInt(s[s.length - 1]);
            s = br.readLine().split(sep);
            minx = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            miny = Double.parseDouble(s[s.length - 1]);
            s = br.readLine().split(sep);
            cellsize = Double.parseDouble(s[s.length - 1]);
            maxx = minx + (double)width * cellsize;
            maxy = miny + (double)height * cellsize;
            s = br.readLine().split(sep);
            if (!s[0].equalsIgnoreCase("NODATA_value")) {
                noDataValue = Raster.getNoDataValue();
                br.close();
                throw new NumberFormatException();
            }
            noDataValue = Integer.parseInt(s[s.length - 1]);
            Raster.setNoDataValue(noDataValue);
            Double[][] values = new Double[height][];
            ArrayList<Double> lValues = new ArrayList<Double>();
            int j = 0;
            while (br.ready()) {
                System.out.println(j);
                lValues.clear();
                line = br.readLine();
                String[] datas = line.split(" ");
                double lastv = 0.0;
                double count = 0.0;
                for (int i = 0; i < width; ++i) {
                    double v = Double.parseDouble(datas[i]);
                    if (i == 0) {
                        lastv = v;
                        count += 1.0;
                        continue;
                    }
                    if (v == lastv) {
                        count += 1.0;
                        continue;
                    }
                    lValues.add(count);
                    lValues.add(lastv);
                    lastv = v;
                    count = 1.0;
                }
                values[j++] = lValues.toArray(new Double[lValues.size()]);
            }
            br.close();
            ConwayMatrix m = new ConwayMatrix(cellsize, minx, maxx, miny, maxy, width, height, values);
            return m;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Matrix create(Matrix mRef) {
        return null;
    }

    @Override
    public Matrix create(Matrix mRef, int divisor) {
        return null;
    }

    @Override
    public Matrix create(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noData) {
        return null;
    }

    @Override
    public Matrix create(int width, int height, double cellsize, double minX, double maxX, double minY, double maxY, int noData, PlanarImage ref) {
        return null;
    }

    static {
        noDataValue = -1;
        factory = new ConwayMatrixFactory();
    }
}

