/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.time.period;

import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.Time;
import fr.inra.sad.bagap.apiland.core.time.period.Moment;
import fr.inra.sad.bagap.apiland.core.time.period.Month;
import java.util.StringTokenizer;

public class Date
extends Moment {
    private static final long serialVersionUID = 1L;
    private int day;
    private int month;

    protected Date() {
    }

    public Date(Instant t) {
        this(Time.getDayOfYear(t), Time.getMonth(t));
    }

    public Date(int dayOfYear) {
        int d = dayOfYear % 365;
        if (d <= 31) {
            this.day = d;
            this.month = 1;
        } else if (d <= 59) {
            this.day = d - 31;
            this.month = 2;
        } else if (d <= 90) {
            this.day = d - 59;
            this.month = 3;
        } else if (d <= 120) {
            this.day = d - 90;
            this.month = 4;
        } else if (d <= 151) {
            this.day = d - 120;
            this.month = 5;
        } else if (d <= 181) {
            this.day = d - 151;
            this.month = 6;
        } else if (d <= 212) {
            this.day = d - 181;
            this.month = 7;
        } else if (d <= 243) {
            this.day = d - 212;
            this.month = 8;
        } else if (d <= 273) {
            this.day = d - 243;
            this.month = 9;
        } else if (d <= 304) {
            this.day = d - 273;
            this.month = 10;
        } else if (d <= 334) {
            this.day = d - 304;
            this.month = 11;
        } else {
            this.day = d - 334;
            this.month = 12;
        }
    }

    public Date(int day, Month month) {
        if (day <= 0 || day > month.getDayCount()) {
            throw new IllegalArgumentException("wrong day number");
        }
        this.day = day;
        this.month = month.getMonthNumber();
    }

    public Date(int day, int month) {
        if (day <= 0 || day > Month.getDayCount(month)) {
            throw new IllegalArgumentException("wrong day number");
        }
        this.day = day;
        this.month = month;
    }

    public Date(String date) {
        StringTokenizer st = new StringTokenizer(date, "/");
        this.day = new Integer(st.nextToken());
        this.month = new Integer(st.nextToken());
    }

    public Instant getInstantThisYear(int year) {
        return Instant.get(this.day, this.month, year);
    }

    @Override
    public Date getBefore(boolean bissextile, int delay) {
        return new Date(this.getDayOfYear(bissextile) - delay);
    }

    @Override
    public Date getAfter(boolean bissextile, int delay) {
        return new Date(this.getDayOfYear(bissextile) + delay);
    }

    public String toString() {
        return this.day + "/" + this.month;
    }

    public boolean equals(Object o) {
        return o instanceof Date && this.day == ((Date)o).day && this.month == ((Date)o).month;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    @Override
    public boolean isActive(Instant t) {
        return this.day == Time.getDayOfMonth(t) && this.month == Time.getMonth(t);
    }

    public int getDayOfYear(boolean bissextile) {
        return this.day + Month.getCumulDay(bissextile, this.month);
    }

    @Override
    public Date end() {
        return this;
    }

    @Override
    public Date start() {
        return this;
    }

    public boolean isBefore(Date date) {
        if (this.month < date.month) {
            return true;
        }
        if (this.month > date.month) {
            return false;
        }
        if (this.day < date.day) {
            return true;
        }
        if (this.day > date.day) {
            return false;
        }
        return false;
    }

    public boolean isAfter(Date date) {
        if (this.month > date.month) {
            return true;
        }
        if (this.month < date.month) {
            return false;
        }
        if (this.day > date.day) {
            return true;
        }
        if (this.day < date.day) {
            return false;
        }
        return false;
    }
}

