/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.core.util;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.core.util.Fourchette;
import fr.inra.sad.bagap.apiland.core.util.Interface;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class InterfaceManager<E extends Comparable<E>> {
    private Map<Interface<E>, Integer> interfaces;
    private int total;
    private Map<Interface<E>, Double> mauvais;

    public InterfaceManager() {
        this.reset();
    }

    public void reset() {
        this.interfaces = new TreeMap<Interface<E>, Integer>();
        this.total = 0;
        this.mauvais = new HashMap<Interface<E>, Double>();
    }

    private boolean contains(E e1, E e2) {
        for (Interface<E> i : this.interfaces.keySet()) {
            if (!i.contains(e1, e2)) continue;
            return true;
        }
        return false;
    }

    private void set(E e1, E e2) {
        this.interfaces.put(new Interface<E>(e1, e2), 0);
    }

    private Interface<E> get(E e1, E e2) {
        for (Interface<E> i : this.interfaces.keySet()) {
            if (!i.contains(e1, e2)) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    private void add(Interface<E> i) {
        this.interfaces.put(i, this.interfaces.get(i) + 1);
        ++this.total;
    }

    public void add(E e1, E e2) {
        if (!this.contains(e1, e2)) {
            this.set(e1, e2);
        }
        this.add(this.get(e1, e2));
    }

    public void display() {
        for (Map.Entry<Interface<E>, Integer> e : this.interfaces.entrySet()) {
            System.out.println(e.getKey() + " --> " + e.getValue() + ", soit " + new Double(e.getValue().intValue()) * 100.0 / (double)this.total + "%");
        }
    }

    public void export(String f) {
        try {
            CsvWriter cw = new CsvWriter(f);
            cw.setDelimiter(';');
            for (Map.Entry<Interface<E>, Integer> e : this.interfaces.entrySet()) {
                cw.write(e.getKey() + " --> " + e.getValue() + ", soit " + new Double(e.getValue().intValue()) * 100.0 / (double)this.total + "%");
                cw.endRecord();
            }
            cw.close();
        }
        catch (CsvWriter.FinalizedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<Interface<E>, Double> gets() {
        HashMap<Interface<E>, Double> results = new HashMap<Interface<E>, Double>();
        for (Map.Entry<Interface<E>, Integer> e : this.interfaces.entrySet()) {
            results.put(e.getKey(), new Double(e.getValue().intValue()) * 100.0 / (double)this.total);
        }
        return results;
    }

    public double note(Map<Interface<E>, Fourchette> f) {
        double note = 0.0;
        this.mauvais.clear();
        for (Map.Entry<Interface<E>, Double> e : this.gets().entrySet()) {
            double d = f.get(e.getKey()).distance(e.getValue());
            if (d != 0.0) {
                note += Math.abs(d);
            }
            if ((d = f.get(e.getKey()).distanceToBeSure(e.getValue(), 0.5)) == 0.0) continue;
            this.mauvais.put(e.getKey(), d);
        }
        return note;
    }

    public Map<Interface<E>, Double> getMauvais() {
        return this.mauvais;
    }

    public double getPourcentage(int v) {
        return (double)v * 100.0 / (double)this.total;
    }
}

