/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.domain;

import fr.inra.sad.bagap.apiland.domain.Domain;
import fr.inra.sad.bagap.apiland.domain.SimpleDomain;

public class NumberDomain<D extends Number, E extends Number>
extends SimpleDomain<D, E> {
    private String operator;

    public NumberDomain(String operator, D value) {
        super(value);
        this.operator = operator;
    }

    public NumberDomain(String operator, D value, Domain<D, E> inverse) {
        super(value, inverse);
        this.operator = operator;
    }

    public String toString() {
        return this.operator + " " + this.value();
    }

    @Override
    public boolean accept(Number v) {
        double vv = v.doubleValue();
        switch (this.operator) {
            case "=": {
                return vv == ((Number)this.value()).doubleValue();
            }
            case "!=": {
                return vv != ((Number)this.value()).doubleValue();
            }
            case "<": {
                return vv < ((Number)this.value()).doubleValue();
            }
            case ">": {
                return vv > ((Number)this.value()).doubleValue();
            }
            case "<=": {
                return vv <= ((Number)this.value()).doubleValue();
            }
            case ">=": {
                return vv >= ((Number)this.value()).doubleValue();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Domain<D, E> inverse() {
        if (this.inverse == null) {
            String op = "";
            switch (this.operator) {
                case "=": {
                    op = "!=";
                    break;
                }
                case "!=": {
                    op = "=";
                    break;
                }
                case "<": {
                    op = ">=";
                    break;
                }
                case ">": {
                    op = "<=";
                    break;
                }
                case "<=": {
                    op = ">";
                    break;
                }
                case ">=": {
                    op = "<";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.inverse = new NumberDomain<Number, E>(op, (Number)this.value(), this);
        }
        return this.inverse;
    }

    public String operator() {
        return this.operator;
    }
}

