/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.patch;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.patch.Envelope;
import fr.inra.sad.bagap.apiland.patch.Patch;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SetPatch
implements Patch {
    private int value;
    private Set<Pixel> pixels;

    public SetPatch(int v) {
        this.value = v;
        this.pixels = new TreeSet<Pixel>();
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean touches(Pixel p) {
        for (Pixel px : this.pixels) {
            if (!px.touches(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Pixel p) {
        for (Pixel px : this.pixels) {
            if (!px.equals(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void add(Pixel p) {
        this.pixels.add(p);
    }

    @Override
    public void addAll(Patch pa) {
        this.pixels.addAll(pa.pixels());
    }

    @Override
    public Set<Pixel> pixels() {
        return this.pixels;
    }

    @Override
    public void remove(Pixel p) {
        this.pixels.remove(p);
    }

    @Override
    public int size() {
        return this.pixels.size();
    }

    @Override
    public double getArea() {
        return (double)this.size() * Pixel.getCellSize() * Pixel.getCellSize();
    }

    @Override
    public void display() {
        for (Pixel p : this.pixels) {
            System.out.print(p + ", ");
        }
        System.out.println();
    }

    @Override
    public void upPixels() {
        Iterator<Pixel> ite = this.pixels.iterator();
        while (ite.hasNext()) {
            Pixel p = ite.next();
            if (p.y() == 0) {
                ite.remove();
                continue;
            }
            p.setY(p.y() - 1);
        }
    }

    @Override
    public Pixel pixel() {
        return this.pixels.iterator().next();
    }

    @Override
    public boolean equals(Patch pi) {
        return this.pixels.iterator().next().equals(pi.pixels().iterator().next());
    }

    @Override
    public Envelope getEnvelope() {
        return null;
    }
}

