/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul;

import fr.inra.sad.bagap.apiland.core.element.map.DynamicMap;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.simul.OutputManager;
import fr.inra.sad.bagap.apiland.simul.Scenario;
import fr.inra.sad.bagap.apiland.simul.SimulationManager;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import fr.inra.sad.bagap.apiland.simul.model.APILandModel;
import fr.inra.sad.bagap.apiland.simul.model.ModelManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class Simulation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scenario scenario;
    protected boolean run;
    private boolean cancel;
    private int number;
    private APILandModel model;
    private String folder;

    public Simulation(Scenario scenario, int number) {
        this.scenario = scenario;
        this.number = number;
        this.cancel = false;
    }

    public String toString() {
        return "simulation_" + this.scenario.number() + "_" + this.number;
    }

    public String folder() {
        return this.folder;
    }

    public SimulationManager manager() {
        return this.scenario.manager();
    }

    public Simulator simulator() {
        return this.scenario.simulator();
    }

    public OutputManager outputs() {
        return this.scenario.outputs();
    }

    public int number() {
        return this.number;
    }

    public Scenario scenario() {
        return this.scenario;
    }

    protected void init() {
        this.model = this.scenario.model();
        this.model.setSimulation(this);
        this.model.setCurrent(this.manager().start());
        this.folder = this.manager().outputFolder() + "scenario_" + this.scenario.number() + "/simulation_" + this.number + "/";
        new File(this.folder).mkdir();
        this.run = false;
        this.initModel();
        this.outputs().init(this);
    }

    protected void initModel() {
    }

    public boolean run() {
        this.manager().display("run simulation " + this.simulator().number() + "_" + this.scenario().number() + "_" + this.number);
        this.model.initCurrent(this.manager().start());
        if (!(this.run || this.manager().isCancelled() || this.model.run(this.manager().end()))) {
            return false;
        }
        this.outputs().calculate(this);
        return true;
    }

    private void loadModel() {
        try {
            this.model = (APILandModel)ModelManager.load(this.scenario().folder() + "/scenario.model");
            this.model.setSimulation(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void saveModel() {
        try {
            ModelManager.save(this.model, this.folder + "simulation.model");
            this.model = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void close() {
        this.manager().display("close simulation " + this.simulator().number() + "_" + this.scenario().number() + "_" + this.number);
        this.run = true;
        this.outputs().close(this);
        File folderFile = new File(this.folder);
        if (folderFile != null && folderFile.list() != null && folderFile.list().length == 0) {
            folderFile.delete();
        }
    }

    public APILandModel model() {
        return this.model;
    }

    public DynamicMap map() {
        return this.model.map();
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void abort(Instant t, String message) {
        this.manager().setCancelled(true);
        this.cancel = true;
        System.err.println(this + " was interrupted at " + t + " : " + message);
    }

    public void delete() {
        this.scenario = null;
        this.model = null;
    }

    public void deleteSuccess() {
        this.cancel = true;
        this.scenario.deleteSuccess();
    }
}

