/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.model;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.simul.Simulator;
import fr.inra.sad.bagap.apiland.simul.model.Model;

public abstract class AtomicModel
extends Model {
    private static final long serialVersionUID = 1L;
    private Delay delay;

    public AtomicModel(String name, Simulator simulator, DynamicElement element) {
        super(name, simulator, element);
        this.delay = simulator.manager().delay();
    }

    public AtomicModel(String name, Instant start, Delay delay, Simulator simulator, DynamicElement element) {
        super(name, start, simulator, element);
        this.delay = delay;
    }

    @Override
    public boolean run(Instant t) {
        while (this.current().isBefore(t) || this.current().equals(t)) {
            if (this.make(this.current())) {
                this.setCurrent(this.delay.next(this.current()));
                continue;
            }
            return false;
        }
        return true;
    }

    public Delay getDelay() {
        return this.delay;
    }

    public abstract boolean make(Instant var1);

    @Override
    public void delete() {
        super.delete();
        this.delay = null;
    }
}

