/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.operation;

import fr.inra.sad.bagap.apiland.core.element.DynamicElement;
import fr.inra.sad.bagap.apiland.core.element.DynamicLayer;
import fr.inra.sad.bagap.apiland.core.time.Instant;
import fr.inra.sad.bagap.apiland.core.time.delay.Delay;
import fr.inra.sad.bagap.apiland.core.util.TransitionMatrix;
import fr.inra.sad.bagap.apiland.simul.operation.OpComposition;
import fr.inra.sad.bagap.apiland.simul.operation.OpTypeTransitionMatrix;
import java.io.Serializable;
import java.util.Iterator;

public class OpTransitionMatrix
extends OpComposition {
    private static final long serialVersionUID = 1L;
    private TransitionMatrix<?> tMat;
    private Delay delay;

    public OpTransitionMatrix(OpTypeTransitionMatrix type) {
        super(type);
        this.tMat = type.getTransitionMatrix();
        this.delay = type.getDelay();
    }

    @Override
    public OpTransitionMatrix clone() {
        OpTransitionMatrix clone = (OpTransitionMatrix)super.clone();
        clone.tMat = this.tMat;
        clone.delay = this.delay;
        return clone;
    }

    @Override
    public boolean make(Instant t, DynamicElement ... e) {
        Instant previous = this.delay.previous(t);
        Iterator ite = ((DynamicLayer)e[0]).activeDeepIterator(t);
        while (ite.hasNext()) {
            DynamicElement de = (DynamicElement)ite.next();
            Object last = de.getAttribute(this.getAttribute()).getValue(previous);
            de.getAttribute(this.getAttribute()).setValue(t, (Serializable)this.tMat.getTransition((Serializable)last));
        }
        return true;
    }

    @Override
    public void delete() {
        super.delete();
        this.tMat = null;
        this.delay = null;
    }
}

