/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment.window;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.MapCsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetricManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysisBuilder;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.FilteredRectangularWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.CornerWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.cluster.Cluster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.treatment.GlobalTreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.Treatment;
import java.util.Set;

public class ClusteredWindowMatrixTreatment
extends Treatment
implements AnalysisObserver {
    private Matrix matrix;
    private CsvWriter csv;
    private Set<String> metrics;
    private Set<Cluster> clusters;

    public ClusteredWindowMatrixTreatment() {
        super("clustered", GlobalTreatmentManager.get());
        this.defineInput("matrix", Matrix.class);
        this.defineInput("metrics", Set.class);
        this.defineInput("csv", CsvWriter.class);
        this.defineInput("clusters", Set.class);
    }

    @Override
    protected void doInit() {
        this.matrix = (Matrix)this.getInput("matrix");
        this.metrics = (Set)this.getInput("metrics");
        this.csv = (CsvWriter)this.getInput("csv");
        this.clusters = (Set)this.getInput("clusters");
    }

    @Override
    protected void doRun() {
        Window w;
        WindowMatrixProcessType pt = new WindowMatrixProcessType(false, this.matrix);
        for (String metric : this.metrics) {
            pt.addMetric(MatrixMetricManager.get(metric));
        }
        Window[] ws = new Window[this.clusters.size()];
        int index = 0;
        for (Cluster c : this.clusters) {
            w = new CornerWindow(new FilteredRectangularWindow(c));
            ws[index++] = w;
        }
        w = new MultipleWindow(ws);
        WindowMatrixAnalysisBuilder builder = new WindowMatrixAnalysisBuilder(WindowAnalysisType.AREA);
        builder.addMatrix(this.matrix);
        builder.setWindow(w);
        builder.setClusters(this.clusters);
        builder.setProcessType(pt);
        builder.addObserver(new MapCsvOutput(this.metrics, this.csv));
        Object wa = builder.build();
        ((Analysis)wa).addObserver(this);
        ((Analysis)wa).allRun();
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }
}

