/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment.window;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.GridAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.GridCsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.HeaderGridAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetricManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysisBuilder;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.SquareWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.CornerWindow;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.treatment.GlobalTreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.Treatment;
import java.util.Set;

public class GridWindowMatrixTreatment
extends Treatment
implements AnalysisObserver {
    private Matrix matrix;
    private int gridSize;
    private String csv;
    private String ascii;
    private double minRate;
    private Set<String> metrics;

    public GridWindowMatrixTreatment() {
        super("grid", GlobalTreatmentManager.get());
        this.defineInput("matrix", Matrix.class);
        this.defineInput("grid_size", Integer.class);
        this.defineInput("min_rate", Double.class);
        this.defineInput("metrics", Set.class);
        this.defineInput("csv", String.class);
        this.defineInput("ascii", String.class);
    }

    @Override
    protected void doInit() {
        this.matrix = (Matrix)this.getInput("matrix");
        this.gridSize = (Integer)this.getInput("grid_size");
        this.minRate = (Double)this.getInput("min_rate");
        this.metrics = (Set)this.getInput("metrics");
        this.csv = (String)this.getInput("csv");
        this.ascii = (String)this.getInput("ascii");
    }

    @Override
    protected void doRun() {
        WindowMatrixProcessType pt = new WindowMatrixProcessType(false, this.matrix);
        for (String metric : this.metrics) {
            pt.addMetric(MatrixMetricManager.get(metric));
        }
        CornerWindow w = new CornerWindow(new SquareWindow(this.gridSize, null));
        WindowMatrixAnalysisBuilder builder = new WindowMatrixAnalysisBuilder(WindowAnalysisType.GRID);
        builder.addMatrix(this.matrix);
        builder.setWindow(w);
        builder.setProcessType(pt);
        builder.setDisplacement(this.gridSize);
        builder.setMinRate(this.minRate);
        if (this.csv != null) {
            builder.addObserver(new GridCsvOutput(this.gridSize, this.matrix, this.csv));
            builder.addObserver(new HeaderGridAsciiGridOutput(this.gridSize, this.csv.replace(".csv", "") + "_header.txt"));
        }
        if (this.ascii != null) {
            if (this.ascii.endsWith(".asc") && this.metrics.size() == 1) {
                for (String metric : this.metrics) {
                    builder.addObserver(new GridAsciiGridOutput(this.gridSize, metric, this.ascii, this.gridSize));
                }
            } else {
                for (String metric : this.metrics) {
                    builder.addObserver(new GridAsciiGridOutput(this.gridSize, metric, this.ascii + metric + ".asc", this.gridSize));
                }
            }
        }
        Object wa = builder.build();
        ((Analysis)wa).addObserver(this);
        ((Analysis)wa).allRun();
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }
}

