/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment.window;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.combination.CombinationExpressionFactory;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.SelectedAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.SelectedCsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.MultipleWindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetricManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysisBuilder;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.CombinationExpressionDistanceFunction;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.distance.DistanceFunction;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.CenteredWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.type.Window;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.treatment.GlobalTreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.Treatment;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SelectedWindowMatrixTreatment
extends Treatment
implements AnalysisObserver {
    private Matrix matrix;
    private WindowShapeType shape;
    private List<Integer> windowSizes;
    private Set<Pixel> pixels;
    private double minRate;
    private String csv;
    private String ascii;
    private Friction frictionMap;
    private Matrix frictionMatrix;
    private Set<String> metrics;
    private String path;
    private boolean distanceType;
    private String distanceFunction;

    public SelectedWindowMatrixTreatment() {
        super("selected", GlobalTreatmentManager.get());
        this.defineInput("matrix", Matrix.class);
        this.defineInput("shape", WindowShapeType.class);
        this.defineInput("friction_map", Friction.class);
        this.defineInput("friction_matrix", Matrix.class);
        this.defineInput("min_rate", Double.class);
        this.defineInput("window_sizes", List.class);
        this.defineInput("pixels", Set.class);
        this.defineInput("metrics", Set.class);
        this.defineInput("csv", String.class);
        this.defineInput("ascii", String.class);
        this.defineInput("path", String.class);
        this.defineInput("distance_type", Boolean.class);
        this.defineInput("distance_function", String.class);
    }

    @Override
    protected void doInit() {
        this.matrix = (Matrix)this.getInput("matrix");
        this.shape = (WindowShapeType)((Object)this.getInput("shape"));
        this.frictionMap = (Friction)this.getInput("friction_map");
        this.frictionMatrix = (Matrix)this.getInput("friction_matrix");
        this.windowSizes = (List)this.getInput("window_sizes");
        this.minRate = (Double)this.getInput("min_rate");
        this.metrics = (Set)this.getInput("metrics");
        this.csv = (String)this.getInput("csv");
        this.ascii = (String)this.getInput("ascii");
        this.pixels = (Set)this.getInput("pixels");
        this.path = (String)this.getInput("path");
        this.distanceType = (Boolean)this.getInput("distance_type");
        this.distanceFunction = (String)this.getInput("distance_function");
    }

    @Override
    protected void doRun() {
        Window w;
        WindowMatrixProcessType pt = this.windowSizes.size() == 1 ? new WindowMatrixProcessType(this.distanceType, this.matrix) : new MultipleWindowMatrixProcessType(this.distanceType, this.matrix);
        for (String metric : this.metrics) {
            pt.addMetric(MatrixMetricManager.get(metric));
        }
        if (this.windowSizes.size() == 1) {
            CombinationExpressionDistanceFunction function = null;
            if (this.distanceType) {
                double dMax = (double)((this.windowSizes.get(0) - 1) / 2) * Raster.getCellSize();
                function = CombinationExpressionFactory.createDistanceFunction(this.distanceFunction, dMax);
            }
            w = this.frictionMap != null ? new CenteredWindow(this.shape.create(this.matrix, (double)(this.windowSizes.get(0) - 1) * this.matrix.cellsize() / 2.0, this.frictionMap, pt, (DistanceFunction)function)) : (this.frictionMatrix != null ? new CenteredWindow(this.shape.create(this.matrix, (double)(this.windowSizes.get(0) - 1) * this.matrix.cellsize() / 2.0, this.frictionMatrix, pt, (DistanceFunction)function)) : new CenteredWindow(this.shape.create(this.windowSizes.get(0), (DistanceFunction)function)));
        } else {
            Collections.sort(this.windowSizes);
            Collections.reverse(this.windowSizes);
            Window[] ws = new Window[this.windowSizes.size()];
            for (int i = 0; i < this.windowSizes.size(); ++i) {
                CombinationExpressionDistanceFunction function = null;
                if (this.distanceType) {
                    double dMax = (double)((this.windowSizes.get(i) - 1) / 2) * Raster.getCellSize();
                    function = CombinationExpressionFactory.createDistanceFunction(this.distanceFunction, dMax);
                }
                ws[i] = this.frictionMap != null ? new CenteredWindow(this.shape.create(this.matrix, (double)this.windowSizes.get(i).intValue() * this.matrix.cellsize() / 2.0, this.frictionMap, pt, (DistanceFunction)function)) : (this.frictionMatrix != null ? new CenteredWindow(this.shape.create(this.matrix, (double)this.windowSizes.get(i).intValue() * this.matrix.cellsize() / 2.0, this.frictionMatrix, pt, (DistanceFunction)function)) : new CenteredWindow(this.shape.create(this.windowSizes.get(i), (DistanceFunction)function)));
            }
            w = new MultipleWindow(ws);
        }
        WindowMatrixAnalysisBuilder builder = new WindowMatrixAnalysisBuilder(WindowAnalysisType.SELECTED);
        builder.addMatrix(this.matrix);
        builder.setWindow(w);
        builder.setProcessType(pt);
        builder.setMinRate(this.minRate);
        builder.setPixels(this.pixels);
        builder.setPath(this.path);
        if (this.csv != null) {
            builder.addObserver(new SelectedCsvOutput(this.matrix, this.csv, this.pixels));
        }
        if (this.ascii != null) {
            builder.setExportFilters(true);
            if (this.ascii.endsWith(".asc") && this.metrics.size() == 1 && this.windowSizes.size() == 1) {
                String metric = this.metrics.iterator().next();
                builder.addObserver(new SelectedAsciiGridOutput(metric, this.ascii, this.matrix.width(), this.matrix.height()));
            } else {
                for (String metric : this.metrics) {
                    if (this.windowSizes.size() == 1) {
                        builder.addObserver(new SelectedAsciiGridOutput(metric, this.ascii + "w" + this.windowSizes.get(0) + "_" + metric + ".asc", this.matrix.width(), this.matrix.height()));
                        continue;
                    }
                    for (int size : this.windowSizes) {
                        builder.addObserver(new SelectedAsciiGridOutput("w" + size + "_" + metric, this.ascii + "w" + size + "_" + metric + ".asc", this.matrix.width(), this.matrix.height()));
                    }
                }
            }
        } else {
            builder.setExportFilters(false);
        }
        Object wa = builder.build();
        ((Analysis)wa).addObserver(this);
        ((Analysis)wa).allRun();
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }
}

