/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.raster;

import org.locationtech.jts.geom.Envelope;

public class EnteteRaster {
    private int width;
    private int height;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private float cellsize;
    private int noDataValue;

    public EnteteRaster(int width, int height, double minx, double maxx, double miny, double maxy, float cellsize, int noDataValue) {
        this.width = width;
        this.height = height;
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.cellsize = cellsize;
        this.noDataValue = noDataValue;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public double minx() {
        return this.minx;
    }

    public double maxx() {
        return this.maxx;
    }

    public double miny() {
        return this.miny;
    }

    public double maxy() {
        return this.maxy;
    }

    public float cellsize() {
        return this.cellsize;
    }

    public int noDataValue() {
        return this.noDataValue;
    }

    public static EnteteRaster getEntete(Envelope envelope, float cellsize, int noDataValue) {
        int ncols = (envelope.getMaxX() - envelope.getMinX()) % (double)cellsize == 0.0 ? new Double(Math.floor((envelope.getMaxX() - envelope.getMinX()) / (double)cellsize)).intValue() : new Double(Math.floor((envelope.getMaxX() - envelope.getMinX()) / (double)cellsize) + 1.0).intValue();
        int nrows = (envelope.getMaxY() - envelope.getMinY()) % (double)cellsize == 0.0 ? new Double(Math.floor((envelope.getMaxY() - envelope.getMinY()) / (double)cellsize)).intValue() : new Double(Math.floor((envelope.getMaxY() - envelope.getMinY()) / (double)cellsize) + 1.0).intValue();
        return new EnteteRaster(ncols, nrows, envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY(), cellsize, noDataValue);
    }
}

