/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class BrowserLauncher
implements PlugIn {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static Object linkage;
    private static final String JDirect_MacOSX = "/System/Library/Frameworks/Carbon.framework/Frameworks/HIToolbox.framework/HIToolbox";
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS = 5;
    private static final int MACOSX = 6;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static String errorMessage;

    static {
        block11: {
            loadedWithoutErrors = true;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS X")) {
                jvm = 6;
            } else if (osName.startsWith("Mac OS")) {
                String mrjVersion = System.getProperty("mrj.version");
                String majorMRJVersion = mrjVersion.substring(0, 3);
                try {
                    double version = Double.valueOf(majorMRJVersion);
                    if (version == 2.0) {
                        jvm = 0;
                        break block11;
                    }
                    if (version >= 2.1 && version < 3.0) {
                        jvm = 1;
                        break block11;
                    }
                    if (version == 3.0) {
                        jvm = 3;
                        break block11;
                    }
                    if (version >= 3.1) {
                        jvm = 4;
                        break block11;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + version;
                }
                catch (NumberFormatException nfe) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + mrjVersion;
                }
            } else {
                jvm = osName.startsWith("Windows") ? 5 : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }

    public void run(String theURL) {
        if (theURL == null || theURL.equals("")) {
            theURL = "http://rsb.info.nih.gov/ij/";
        } else if (theURL.equals("online")) {
            theURL = "http://rsb.info.nih.gov/ij/docs";
        }
        Applet applet = IJ.getApplet();
        if (applet != null) {
            try {
                applet.getAppletContext().showDocument(new URL(theURL), "_blank");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            BrowserLauncher.openURL(theURL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = systemFolderField.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", File.class);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (SecurityException se) {
                    errorMessage = se.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 6: {
                try {
                    if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                        mrjFileUtilsClass = Class.forName("com.apple.cocoa.application.NSWorkspace", true, classLoader);
                    } else {
                        mrjFileUtilsClass = Class.forName("com.apple.cocoa.application.NSWorkspace");
                    }
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", URL.class);
                    break;
                }
                catch (Exception e) {
                    IJ.log("MaxOSX: " + e);
                    errorMessage = e.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                return null;
            }
            case 1: {
                File systemFolder;
                try {
                    systemFolder = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException iare) {
                    browser = null;
                    errorMessage = iare.getMessage();
                    return browser;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                    return browser;
                }
                String[] systemFolderFiles = systemFolder.list();
                int i = 0;
                while (i < systemFolderFiles.length) {
                    try {
                        Object fileCreator;
                        Object fileType;
                        File file = new File(systemFolder, systemFolderFiles[i]);
                        if (file.isFile() && FINDER_TYPE.equals((fileType = getFileType.invoke(null, file)).toString()) && FINDER_CREATOR.equals((fileCreator = getFileCreator.invoke(null, file)).toString())) {
                            browser = file.toString();
                            return browser;
                        }
                    }
                    catch (IllegalArgumentException iare) {
                        errorMessage = iare.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        browser = null;
                        errorMessage = iae.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException ite) {
                        browser = null;
                        errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                        return browser;
                    }
                    ++i;
                }
                browser = null;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                browser = "";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String url) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        switch (jvm) {
            case 1: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
                break;
            }
            case 6: {
                try {
                    Method aMethod = mrjFileUtilsClass.getDeclaredMethod("sharedWorkspace", new Class[0]);
                    Object aTarget = aMethod.invoke((Object)mrjFileUtilsClass, new Object[0]);
                    openURL.invoke(aTarget, new URL(url));
                }
                catch (Exception e) {
                    errorMessage = "" + e;
                }
                break;
            }
            case 5: {
                String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                if (IJ.debugMode) {
                    IJ.log("Exec: " + cmd);
                }
                Process process = Runtime.getRuntime().exec(cmd);
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case -1: {
                Process process = Runtime.getRuntime().exec(new String[]{(String)browser, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + url + NETSCAPE_OPEN_PARAMETER_END});
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)browser, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
            }
        }
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);
}

