/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.JpegWriter;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;

public class Options
implements PlugIn {
    public void run(String arg) {
        if (arg.equals("misc")) {
            this.miscOptions();
            return;
        }
        if (arg.equals("line")) {
            this.lineWidth();
            return;
        }
        if (arg.equals("io")) {
            this.io();
            return;
        }
        if (arg.equals("point")) {
            this.pointToolOptions();
            return;
        }
        if (arg.equals("conv")) {
            this.conversions();
            return;
        }
        if (arg.equals("display")) {
            this.displayOptions();
            return;
        }
    }

    void miscOptions() {
        String key = IJ.isMacintosh() ? "Command" : "Control";
        GenericDialog gd = new GenericDialog("Miscellaneous Options", IJ.getInstance());
        gd.addStringField("Divide by Zero Value:", "" + FloatBlitter.divideByZeroValue, 10);
        gd.addCheckbox("Use Pointer Cursor", Prefs.usePointerCursor);
        gd.addCheckbox("Hide \"Process Stack?\" Dialog", IJ.hideProcessStackDialog);
        gd.addCheckbox("Antialiased_Tool Icons", Prefs.antialiasedTools);
        gd.addCheckbox("Require " + key + " Key for Shortcuts", Prefs.requireControlKey);
        gd.addCheckbox("Debug Mode", IJ.debugMode);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String divValue = gd.getNextString();
        if (divValue.equalsIgnoreCase("infinity") || divValue.equalsIgnoreCase("infinite")) {
            FloatBlitter.divideByZeroValue = Float.POSITIVE_INFINITY;
        } else if (divValue.equalsIgnoreCase("NaN")) {
            FloatBlitter.divideByZeroValue = Float.NaN;
        } else if (divValue.equalsIgnoreCase("max")) {
            FloatBlitter.divideByZeroValue = Float.MAX_VALUE;
        } else {
            Float f;
            try {
                f = new Float(divValue);
            }
            catch (NumberFormatException e) {
                f = null;
            }
            if (f != null) {
                FloatBlitter.divideByZeroValue = f.floatValue();
            }
        }
        IJ.register(FloatBlitter.class);
        Prefs.usePointerCursor = gd.getNextBoolean();
        IJ.hideProcessStackDialog = gd.getNextBoolean();
        boolean antialiasedTools = gd.getNextBoolean();
        boolean change = antialiasedTools ^ Prefs.antialiasedTools;
        Prefs.antialiasedTools = antialiasedTools;
        if (change) {
            Toolbar.getInstance().repaint();
        }
        Prefs.requireControlKey = gd.getNextBoolean();
        IJ.debugMode = gd.getNextBoolean();
    }

    void lineWidth() {
        int width = (int)IJ.getNumber("Line Width:", Line.getWidth());
        if (width == Integer.MIN_VALUE) {
            return;
        }
        Line.setWidth(width);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && imp.isProcessor()) {
            ImageProcessor ip = imp.getProcessor();
            ip.setLineWidth(Line.getWidth());
            Roi roi = imp.getRoi();
            if (roi != null && roi.isLine()) {
                imp.draw();
            }
        }
    }

    void io() {
        GenericDialog gd = new GenericDialog("I/O Options");
        gd.addNumericField("JPEG Quality (0-100):", JpegWriter.getQuality(), 0, 3, "");
        gd.addStringField("File Extension for Tables:", Prefs.get("options.ext", ".xls"), 4);
        gd.addCheckbox("Use JFileChooser to Open/Save", Prefs.useJFileChooser);
        gd.addCheckbox("Export Raw in Intel Byte Order", Prefs.intelByteOrder);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int quality = (int)gd.getNextNumber();
        if (quality < 0) {
            quality = 0;
        }
        if (quality > 100) {
            quality = 100;
        }
        JpegWriter.setQuality(quality);
        String extension = gd.getNextString();
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        Prefs.set("options.ext", extension);
        Prefs.useJFileChooser = gd.getNextBoolean();
        Prefs.intelByteOrder = gd.getNextBoolean();
        if (!IJ.isJava2()) {
            Prefs.useJFileChooser = false;
        }
    }

    void pointToolOptions() {
        GenericDialog gd = new GenericDialog("Point Tool");
        gd.addNumericField("Mark Width:", Analyzer.markWidth, 0, 2, "pixels");
        gd.addCheckbox("Auto-Measure", Prefs.pointAutoMeasure);
        gd.addCheckbox("Auto-Next Slice", Prefs.pointAutoNextSlice);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int width = (int)gd.getNextNumber();
        if (width < 0) {
            width = 0;
        }
        Analyzer.markWidth = width;
        Prefs.pointAutoMeasure = gd.getNextBoolean();
        Prefs.pointAutoNextSlice = gd.getNextBoolean();
        if (Prefs.pointAutoNextSlice) {
            Prefs.pointAutoMeasure = true;
        }
    }

    void conversions() {
        double[] weights = ColorProcessor.getWeightingFactors();
        boolean weighted = weights[0] != 0.3333333333333333 || weights[1] != 0.3333333333333333 || weights[2] != 0.3333333333333333;
        GenericDialog gd = new GenericDialog("Conversion Options");
        gd.addCheckbox("Scale When Converting", ImageConverter.getDoScaling());
        String prompt = "Weighted RGB Conversions";
        if (weighted) {
            prompt = String.valueOf(prompt) + " (" + IJ.d2s(weights[0]) + "," + IJ.d2s(weights[1]) + "," + IJ.d2s(weights[2]) + ")";
        }
        gd.addCheckbox(prompt, weighted);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ImageConverter.setDoScaling(gd.getNextBoolean());
        Prefs.weightedColor = gd.getNextBoolean();
        if (!Prefs.weightedColor) {
            ColorProcessor.setWeightingFactors(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
        } else if (Prefs.weightedColor && !weighted) {
            ColorProcessor.setWeightingFactors(0.299, 0.587, 0.114);
        }
    }

    void displayOptions() {
        ImagePlus imp;
        GenericDialog gd = new GenericDialog("Display Options", IJ.getInstance());
        gd.addCheckbox("Interpolate Zoomed Images", Prefs.interpolateScaledImages);
        gd.addCheckbox("Open Images at 100%", Prefs.open100Percent);
        gd.addCheckbox("Black Canvas", Prefs.blackCanvas);
        gd.addCheckbox("Use Inverting Lookup Table", Prefs.useInvertingLut);
        gd.addCheckbox("Double Buffer Selections", Prefs.doubleBuffer);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean interpolate = gd.getNextBoolean();
        Prefs.open100Percent = gd.getNextBoolean();
        boolean blackCanvas = gd.getNextBoolean();
        boolean useInvertingLut = gd.getNextBoolean();
        Prefs.doubleBuffer = gd.getNextBoolean();
        if (interpolate != Prefs.interpolateScaledImages) {
            Prefs.interpolateScaledImages = interpolate;
            imp = WindowManager.getCurrentImage();
            if (imp != null) {
                imp.draw();
            }
        }
        if (blackCanvas != Prefs.blackCanvas) {
            ImageWindow win;
            Prefs.blackCanvas = blackCanvas;
            imp = WindowManager.getCurrentImage();
            if (imp != null && (win = imp.getWindow()) != null) {
                if (Prefs.blackCanvas) {
                    win.setForeground(Color.white);
                    win.setBackground(Color.black);
                } else {
                    win.setForeground(Color.black);
                    win.setBackground(Color.white);
                }
                imp.repaintWindow();
            }
        }
        if (useInvertingLut != Prefs.useInvertingLut) {
            this.invertLuts(useInvertingLut);
            Prefs.useInvertingLut = useInvertingLut;
        }
        if (Prefs.doubleBuffer && IJ.isMacOSX()) {
            IJ.error("Double-buffering is built into Mac OS X.");
            Prefs.doubleBuffer = false;
        }
    }

    void invertLuts(boolean useInvertingLut) {
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            ImagePlus imp = WindowManager.getImage(list[i]);
            if (imp == null) {
                return;
            }
            ImageProcessor ip = imp.getProcessor();
            if (useInvertingLut != ip.isInvertedLut() && !ip.isColorLut()) {
                ip.invertLut();
                int nImages = imp.getStackSize();
                if (nImages == 1) {
                    ip.invert();
                } else {
                    ImageStack stack2 = imp.getStack();
                    int slice = 1;
                    while (slice <= nImages) {
                        stack2.getProcessor(slice).invert();
                        ++slice;
                    }
                    stack2.setColorModel(ip.getColorModel());
                }
            }
            ++i;
        }
    }
}

