/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.Binary;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class BinaryFiller
implements PlugInFilter {
    protected boolean backgroundIsZero;

    public int setup(String arg, ImagePlus imp) {
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        ImageStatistics stats = imp.getStatistics();
        if (stats.histogram[0] + stats.histogram[255] != stats.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return 4096;
        }
        this.backgroundIsZero = Binary.blackBackground;
        if (imp.isInvertedLut()) {
            this.backgroundIsZero = !this.backgroundIsZero;
        }
        return IJ.setupDialog(imp, 1);
    }

    public void run(ImageProcessor ip) {
        int x;
        int xe = ip.getWidth();
        int ye = ip.getHeight();
        int[][] pixel = new int[xe][ye];
        if (!this.backgroundIsZero) {
            ip.invert();
        }
        int y = 0;
        while (y < ye) {
            x = 0;
            while (x < xe) {
                pixel[x][y] = ip.getPixel(x, y);
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < ye) {
            if (ip.getPixel(0, y) == 0) {
                ip.putPixel(0, y, 127);
            }
            if (ip.getPixel(xe - 1, y) == 0) {
                ip.putPixel(xe - 1, y, 127);
            }
            ++y;
        }
        x = 0;
        while (x < xe) {
            if (ip.getPixel(x, 0) == 0) {
                ip.putPixel(x, 0, 127);
            }
            if (ip.getPixel(x, ye - 1) == 0) {
                ip.putPixel(x, ye - 1, 127);
            }
            ++x;
        }
        boolean b = true;
        while (b) {
            b = false;
            y = 1;
            while (y < ye - 1) {
                x = 1;
                while (x < xe - 1) {
                    if (ip.getPixel(x, y) == 0 && (ip.getPixel(x, y - 1) == 127 || ip.getPixel(x - 1, y) == 127)) {
                        ip.putPixel(x, y, 127);
                        b = true;
                    }
                    ++x;
                }
                ++y;
            }
            y = ye - 2;
            while (y >= 1) {
                x = xe - 2;
                while (x >= 1) {
                    if (ip.getPixel(x, y) == 0 && (ip.getPixel(x + 1, y) == 127 || ip.getPixel(x, y + 1) == 127)) {
                        ip.putPixel(x, y, 127);
                        b = true;
                    }
                    --x;
                }
                --y;
            }
        }
        y = 0;
        while (y < ye) {
            x = 0;
            while (x < xe) {
                if (ip.getPixel(x, y) == 0) {
                    ip.putPixel(x, y, 255);
                } else {
                    ip.putPixel(x, y, pixel[x][y]);
                }
                ++x;
            }
            ++y;
        }
        if (!this.backgroundIsZero) {
            ip.invert();
        }
    }
}

